/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.schemaspy.Config;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.model.Database;
import org.schemaspy.model.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SequenceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SqlService sqlService;

    public SequenceService(SqlService sqlService) {
        this.sqlService = sqlService;
    }

    public void gatherSequences(Config config, Database database) {
        this.initSequences(config, database);
    }

    private void initSequences(Config config, Database db) {
        String sql = config.getDbProperties().getProperty("selectSequencesSql");
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String sequenceName = rs.getString("sequence_name");
                    Integer startValue = SequenceService.getOptionalInt((ResultSet)rs, (String)"start_value", (int)1);
                    Integer increment = SequenceService.getOptionalInt((ResultSet)rs, (String)"increment", (int)1);
                    Sequence sequence = new Sequence(sequenceName, startValue, increment);
                    db.getSequencesMap().put(sequenceName, sequence);
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve sequences using sql '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }

    private static int getOptionalInt(ResultSet rs, String columnName, int defaultIfNotFound) {
        try {
            return rs.getInt(columnName);
        }
        catch (SQLException sqlException) {
            LOGGER.debug("Failed to get value for column '{}'", (Throwable)sqlException);
            return defaultIfNotFound;
        }
    }
}

