/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.schemaspy.Config;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.model.Database;
import org.schemaspy.model.Routine;
import org.schemaspy.model.RoutineParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RoutineService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SqlService sqlService;

    public RoutineService(SqlService sqlService) {
        this.sqlService = sqlService;
    }

    public void gatherRoutines(Config config, Database database) {
        this.initRoutines(config, database);
        this.initRoutineParameters(config, database);
    }

    private void initRoutines(Config config, Database db) {
        String sql = config.getDbProperties().getProperty("selectRoutinesSql");
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String routineName = rs.getString("routine_name");
                    String routineType = rs.getString("routine_type");
                    String returnType = rs.getString("dtd_identifier");
                    String definitionLanguage = rs.getString("routine_body");
                    String definition = rs.getString("routine_definition");
                    String dataAccess = rs.getString("sql_data_access");
                    String securityType = rs.getString("security_type");
                    boolean deterministic = rs.getBoolean("is_deterministic");
                    String comment = RoutineService.getOptionalString((ResultSet)rs, (String)"routine_comment");
                    Routine routine = new Routine(routineName, routineType, returnType, definitionLanguage, definition, deterministic, dataAccess, securityType, comment);
                    db.getRoutinesMap().put(routineName, routine);
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve stored procedure/function details using sql '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }

    private void initRoutineParameters(Config config, Database db) {
        String sql = config.getDbProperties().getProperty("selectRoutineParametersSql");
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String routineName = rs.getString("specific_name");
                    Routine routine = (Routine)db.getRoutinesMap().get(routineName);
                    if (routine == null) continue;
                    String paramName = rs.getString("parameter_name");
                    String type = rs.getString("dtd_identifier");
                    String mode = rs.getString("parameter_mode");
                    RoutineParameter param = new RoutineParameter(paramName, type, mode);
                    routine.addParameter(param);
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve stored procedure/function details using SQL '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }

    private static String getOptionalString(ResultSet rs, String columnName) {
        try {
            return rs.getString(columnName);
        }
        catch (SQLException sqlException) {
            LOGGER.debug("Failed to get value for column '{}'", (Throwable)sqlException);
            return null;
        }
    }
}

