/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import org.schemaspy.Config;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.model.Database;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.model.TableIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class IndexService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SqlService sqlService;

    public IndexService(SqlService sqlService) {
        this.sqlService = sqlService;
    }

    public void gatherIndexes(Database database, Table table) throws SQLException {
        this.initIndexes(database, table);
        this.initPrimaryKeys(database, table);
    }

    private void initIndexes(Database db, Table table) throws SQLException {
        block17: {
            if (table.isView() || table.isRemote()) {
                return;
            }
            if (this.initIndexes(db, table, Config.getInstance().getDbProperties().getProperty("selectIndexesSql"))) {
                return;
            }
            try (ResultSet rs = this.sqlService.getDatabaseMetaData().getIndexInfo(table.getCatalog(), table.getSchema(), table.getName(), false, true);){
                while (rs.next()) {
                    if (!IndexService.isIndexRow((ResultSet)rs)) continue;
                    IndexService.addIndex((Table)table, (ResultSet)rs);
                }
            }
            catch (SQLException exc) {
                if (table.isLogical()) break block17;
                LOGGER.warn("Unable to extract index info for table '{}' in schema '{}': {}", new Object[]{table.getName(), table.getContainer(), exc});
            }
        }
    }

    private static boolean isIndexRow(ResultSet rs) throws SQLException {
        return rs.getShort("TYPE") != 0 && rs.getShort("ORDINAL_POSITION") > 0;
    }

    private boolean initIndexes(Database db, Table table, String selectIndexesSql) {
        if (selectIndexesSql == null) {
            return false;
        }
        try (PreparedStatement preparedStatement = this.sqlService.prepareStatement(selectIndexesSql, db, table.getName());
             ResultSet rs = preparedStatement.executeQuery();){
            while (rs.next()) {
                if (rs.getShort("TYPE") == 0) continue;
                IndexService.addIndex((Table)table, (ResultSet)rs);
            }
        }
        catch (SQLException sqlException) {
            LOGGER.warn("Failed to query index information with SQL: {}", (Object)selectIndexesSql, (Object)sqlException);
            return false;
        }
        return true;
    }

    private static void addIndex(Table table, ResultSet rs) throws SQLException {
        String indexName = rs.getString("INDEX_NAME");
        if (indexName == null) {
            return;
        }
        TableIndex index = table.getIndex(indexName);
        if (index == null) {
            index = new TableIndex(indexName, !rs.getBoolean("NON_UNIQUE"));
            table.getIndexesMap().put(index.getName(), (Object)index);
        }
        index.addColumn(table.getColumn(rs.getString("COLUMN_NAME")), rs.getString("ASC_OR_DESC"));
    }

    private void initPrimaryKeys(Database database, Table table) throws SQLException {
        block39: {
            LOGGER.debug("Querying primary keys for {}", (Object)table.getFullName());
            String sql = Config.getInstance().getDbProperties().getProperty("selectPrimaryKeysSql");
            try {
                if (Objects.nonNull(sql)) {
                    try (PreparedStatement preparedStatement = this.sqlService.prepareStatement(sql, database, table.getName());
                         ResultSet resultSet = preparedStatement.executeQuery();){
                        this.processPrimaryKeyResultSet(table, resultSet);
                        break block39;
                    }
                }
                try (ResultSet resultSet = this.sqlService.getDatabaseMetaData().getPrimaryKeys(table.getCatalog(), table.getSchema(), table.getName());){
                    this.processPrimaryKeyResultSet(table, resultSet);
                }
            }
            catch (SQLException exc) {
                if (table.isLogical()) break block39;
                throw exc;
            }
        }
    }

    private void processPrimaryKeyResultSet(Table table, ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            IndexService.addPrimaryKeyColumn((Table)table, (ResultSet)resultSet);
        }
    }

    private static void addPrimaryKeyColumn(Table table, ResultSet rs) throws SQLException {
        String pkName = rs.getString("PK_NAME");
        String columnName = rs.getString("COLUMN_NAME");
        TableColumn tableColumn = table.getColumn(columnName);
        if (Objects.nonNull(tableColumn)) {
            table.setPrimaryColumn(tableColumn);
            IndexService.updateIndex((String)pkName, (Table)table, (TableColumn)tableColumn);
        } else {
            LOGGER.error("Found PrimaryKey index '{}' with column '{}.{}.{}.{}', but was unable to find column in table '{}'", new Object[]{pkName, rs.getString("TABLE_CAT"), rs.getString("TABLE_SCHEM"), rs.getString("TABLE_NAME"), columnName, table.getFullName()});
        }
    }

    private static void updateIndex(String pkName, Table table, TableColumn tableColumn) {
        if (Objects.nonNull(pkName)) {
            TableIndex tableIndex = table.getIndex(pkName);
            if (Objects.nonNull(tableIndex)) {
                tableIndex.setIsPrimaryKey(true);
            } else {
                LOGGER.warn("Found PK for table '{}' with pk name '{}', but index hasn't been found", (Object)table.getName(), (Object)pkName);
            }
        } else {
            String syntheticName = table.getName() + "_s_pk";
            TableIndex tableIndex = Optional.ofNullable(table.getIndex(syntheticName)).orElseGet(() -> {
                LOGGER.info("Found PK without index name created index '{}' for table '{}'", (Object)syntheticName, (Object)table.getName());
                TableIndex syntheticTableIndex = new TableIndex(syntheticName, true);
                table.getIndexesMap().put(syntheticTableIndex.getName(), (Object)syntheticTableIndex);
                return syntheticTableIndex;
            });
            tableIndex.addColumn(tableColumn, null);
            tableIndex.setIsPrimaryKey(true);
            LOGGER.debug("Found PK without index name, added column '{}' to index '{}' in table '{}'", new Object[]{tableColumn.getName(), syntheticName, table.getName()});
        }
    }
}

