/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.config;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;
import org.schemaspy.input.dbms.config.ResourceFinder;
import org.schemaspy.input.dbms.exceptions.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFinder
implements ResourceFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DB_TYPES_LOCATION = "org/schemaspy/types/";

    public URL find(String dbType) {
        String dbTypeToFind = this.addExtensionIfMissing(dbType);
        URL url = this.findFile(dbTypeToFind);
        if (Objects.isNull(url)) {
            url = this.findClassPath(dbTypeToFind);
        }
        if (Objects.isNull(url)) {
            url = this.findClassPath(DB_TYPES_LOCATION + dbTypeToFind);
        }
        if (Objects.isNull(url)) {
            throw new ResourceNotFoundException(dbType);
        }
        return url;
    }

    private String addExtensionIfMissing(String dbType) {
        return dbType.toLowerCase().endsWith(".properties") ? dbType : dbType + ".properties";
    }

    private URL findFile(String file) {
        Path path = Paths.get(file, new String[0]);
        if (path.toFile().exists() && path.toFile().isFile()) {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.debug("Couldn't convert existing file: {}", (Object)path.toString(), (Object)e);
                return null;
            }
        }
        return null;
    }

    private URL findClassPath(String resource) {
        URL url = this.getClass().getClassLoader().getResource(resource);
        if (Objects.nonNull(url)) {
            try {
                Path path;
                if ("jar".equals(url.getProtocol())) {
                    this.ensureFileSystemExists(url);
                    path = this.fixSpringBootPath(url.toString());
                } else {
                    path = Paths.get(url.toURI());
                }
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    return url;
                }
            }
            catch (URISyntaxException e) {
                LOGGER.debug("Couldn't convert url to uri to file: {}", (Object)url, (Object)e);
                return null;
            }
            catch (IOException e) {
                LOGGER.error("Unable to create filesystem for url: {}", (Object)url.toString(), (Object)e);
            }
        }
        return null;
    }

    private Path fixSpringBootPath(String s) {
        URI uri = URI.create(s.replace("classes!", "classes"));
        return Paths.get(uri);
    }

    private void ensureFileSystemExists(URL url) throws URISyntaxException, IOException {
        try {
            FileSystems.getFileSystem(url.toURI());
        }
        catch (FileSystemNotFoundException notFound) {
            FileSystems.newFileSystem(url.toURI(), Collections.singletonMap("create", "false"));
        }
    }
}

