/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.schemaspy.Config;
import org.schemaspy.input.dbms.ConnectionURLBuilder;
import org.schemaspy.input.dbms.exceptions.ConnectionFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbDriverLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Map<String, Driver> driverCache = new HashMap();
    private boolean loadJDBCJars = false;

    public Connection getConnection(Config config) throws IOException {
        Properties properties = config.getDbProperties();
        ConnectionURLBuilder urlBuilder = new ConnectionURLBuilder(config, properties);
        if (Objects.isNull(config.getDb())) {
            config.setDb(urlBuilder.build());
        }
        String[] driverClass = properties.getProperty("driver").split(",");
        String driverPath = properties.getProperty("driverPath");
        if (Objects.isNull(driverPath)) {
            driverPath = "";
        }
        if (Objects.nonNull(config.getDriverPath())) {
            driverPath = config.getDriverPath();
        }
        return this.getConnection(config, urlBuilder.build(), driverClass, driverPath);
    }

    protected Connection getConnection(Config config, String connectionURL, String[] driverClasses, String driverPath) throws IOException {
        Connection connection;
        this.loadJDBCJars = config.isLoadJDBCJarsEnabled();
        Properties connectionProperties = config.getConnectionProperties();
        if (config.getUser() != null) {
            connectionProperties.put("user", config.getUser());
        }
        if (config.getPassword() != null) {
            connectionProperties.put("password", config.getPassword());
        }
        try {
            Driver driver = this.getDriver(driverClasses, driverPath);
            connection = driver.connect(connectionURL, connectionProperties);
            if (connection == null) {
                throw new ConnectionFailure("Cannot connect to '" + connectionURL + "' with driver '" + this.toList(driverClasses) + "'");
            }
        }
        catch (UnsatisfiedLinkError badPath) {
            throw new ConnectionFailure("Error with native library occurred while trying to use driver '" + this.toList(driverClasses) + "'", (Throwable)badPath);
        }
        catch (Exception exc) {
            throw new ConnectionFailure("Failed to connect to database URL [" + connectionURL + "]", (Throwable)exc);
        }
        return connection;
    }

    private String toList(String[] array) {
        if (array.length == 1) {
            return array[0];
        }
        return Stream.of(array).collect(Collectors.joining(","));
    }

    protected synchronized Driver getDriver(String[] driverClasses, String driverPath) {
        ClassLoader loader;
        Class driverClass;
        URL url;
        Driver driver;
        for (String driverClass2 : driverClasses) {
            driver = (Driver)driverCache.get(driverClass2 + "|" + driverPath);
            if (!Objects.nonNull(driver)) continue;
            return driver;
        }
        Set classpath = this.getExistingUrls(driverPath);
        if (classpath.isEmpty() && (url = this.getClass().getResource(driverPath)) != null) {
            classpath = this.getExistingUrls(url.getPath());
        }
        if (this.loadJDBCJars) {
            this.loadAdditionalJarsForDriver(driverPath, classpath);
        }
        if (Objects.isNull(driverClass = this.getDriverClass(driverClasses, loader = this.getDriverClassLoader(classpath)))) {
            throw new ConnectionFailure(this.createMessage(driverClasses, driverPath, classpath));
        }
        try {
            driver = (Driver)driverClass.newInstance();
            if (Objects.nonNull(driver)) {
                driverCache.put(driverClass.getName() + "|" + driverPath, driver);
            }
        }
        catch (Exception exc) {
            throw new ConnectionFailure(this.createMessage(driverClasses, driverPath, classpath), (Throwable)exc);
        }
        return driver;
    }

    private Class<Driver> getDriverClass(String[] driverClasses, ClassLoader loader) {
        Class<Driver> driverClass = null;
        for (String potentialDriverClass : driverClasses) {
            try {
                driverClass = Class.forName(potentialDriverClass, true, loader);
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("Unable to find driverClass '{}'", (Object)potentialDriverClass);
            }
            if (!Objects.nonNull(driverClass)) continue;
            return driverClass;
        }
        return null;
    }

    private String createMessage(String[] driverClass, String driverPath, Set<URI> classpath) {
        StringBuilder sb = new StringBuilder().append("Failed to create any of '").append(Arrays.stream(driverClass).collect(Collectors.joining(", "))).append("' driver from driverPath '").append(driverPath).append("' with sibling jars ").append(this.loadJDBCJars ? "yes" : "no").append(".").append(System.lineSeparator()).append("Resulting in classpath:");
        if (classpath.isEmpty()) {
            sb.append(" empty").append(System.lineSeparator());
        } else {
            sb.append(System.lineSeparator());
            for (URI uri : classpath) {
                sb.append("\t").append(uri.toString()).append(System.lineSeparator());
            }
        }
        List missingPaths = this.getMissingPaths(driverPath);
        if (!missingPaths.isEmpty()) {
            sb.append("There were missing paths in driverPath:").append(System.lineSeparator());
            for (String path : missingPaths) {
                sb.append("\t").append(path).append(System.lineSeparator());
            }
            sb.append("Use commandline option '-dp' to specify driver location.").append(System.lineSeparator()).append("If you need to load sibling jars used '-loadjars'");
        }
        return sb.toString();
    }

    private void loadAdditionalJarsForDriver(String driverPath, Set<URI> classpath) {
        File driverFolder = new File(Paths.get(driverPath, new String[0]).getParent().toString());
        if (driverFolder.exists()) {
            File[] files = driverFolder.listFiles((dir, name) -> name.toLowerCase().matches(".*\\.?ar$"));
            LOGGER.info("Additional files will be loaded for JDBC Driver");
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    classpath.add(file.toURI());
                    LOGGER.info("Added: {}", (Object)file.toURI());
                }
            }
        }
    }

    private ClassLoader getDriverClassLoader(Set<URI> classpath) {
        ClassLoader loader;
        if (!classpath.isEmpty()) {
            URL[] urls = classpath.stream().map(uri -> {
                try {
                    return uri.toURL();
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new URL[classpath.size()]);
            loader = new URLClassLoader(urls);
        } else {
            loader = this.getClass().getClassLoader();
        }
        return loader;
    }

    private List<String> getMissingPaths(String path) {
        String[] pieces;
        ArrayList<String> missingFiles = new ArrayList<String>();
        for (String piece : pieces = path.split(File.pathSeparator)) {
            if (new File(piece).exists()) continue;
            missingFiles.add(piece);
        }
        return missingFiles;
    }

    private Set<URI> getExistingUrls(String path) {
        String[] pieces;
        HashSet<URI> existingUrls = new HashSet<URI>();
        for (String piece : pieces = path.split(File.pathSeparator)) {
            File file = new File(piece);
            if (!file.exists()) continue;
            existingUrls.add(file.toURI());
            if (!file.isDirectory()) continue;
            this.addDirectoryContent(file, existingUrls);
        }
        return existingUrls;
    }

    private void addDirectoryContent(File dir, Set<URI> existingUrls) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (!file.exists()) continue;
            existingUrls.add(file.toURI());
            if (!file.isDirectory()) continue;
            this.addDirectoryContent(file, existingUrls);
        }
    }
}

