/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.schemaspy.Config;
import org.schemaspy.util.DbSpecificConfig;
import org.schemaspy.util.DbSpecificOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionURLBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Config config;
    private final Properties dbType;

    public ConnectionURLBuilder(Config config, Properties properties) {
        this.config = config;
        this.dbType = properties;
    }

    public String build() {
        List args = this.getArgs();
        args.addAll(this.config.getRemainingParameters());
        String connectionURL = this.dbType.getProperty("connectionSpec");
        DbSpecificConfig dbConfig = new DbSpecificConfig(this.config.getDbType(), this.config.getDbProperties());
        for (DbSpecificOption option : dbConfig.getOptions()) {
            option.setValue(this.getParam(args, option));
            LOGGER.debug("{}", (Object)option);
            connectionURL = connectionURL.replaceAll("\\<" + option.getName() + "\\>", option.getValue());
        }
        LOGGER.trace("connectionURL: {}", (Object)connectionURL);
        return connectionURL;
    }

    private List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (String key : this.config.getDbSpecificOptions().keySet()) {
            args.add((key.startsWith("-") ? "" : "-") + key);
            args.add((String)this.config.getDbSpecificOptions().get(key));
        }
        return args;
    }

    private String getParam(List<String> args, DbSpecificOption option) {
        String param = null;
        int paramIndex = args.indexOf("-" + option.getName());
        if (paramIndex < 0) {
            if (this.config != null) {
                param = this.config.getParam(option.getName());
            }
            if ("hostOptionalPort".equals(option.getName())) {
                param = this.getHostOptionalPort();
            }
            if (param == null) {
                throw new Config.MissingRequiredParameterException(option.getName(), option.getDescription(), true);
            }
        } else {
            args.remove(paramIndex);
            param = args.get(paramIndex);
            args.remove(paramIndex);
        }
        return param;
    }

    private String getHostOptionalPort() {
        String hostOptionalPort = this.config.getHost();
        if (hostOptionalPort == null) {
            throw new Config.MissingRequiredParameterException("host", "host of database, may contain port", true);
        }
        String hostPortSeparator = this.dbType.getProperty("hostPortSeparator", ":");
        Integer port = this.config.getPort();
        if (hostOptionalPort.contains(hostPortSeparator)) {
            return hostOptionalPort;
        }
        if (port != null) {
            return hostOptionalPort + hostPortSeparator + port;
        }
        return hostOptionalPort;
    }
}

