/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import org.schemaspy.cli.DegreeOfSeparationValidator;

@Parameters(resourceBundle="commandlinearguments")
public class CommandLineArguments {
    @Parameter(names={"?", "-?", "/?", "-h", "help", "-help", "--help"}, descriptionKey="help", help=true, order=1)
    private boolean helpRequired;
    @Parameter(names={"-dbHelp", "-dbhelp", "--dbHelp", "--dbhelp"}, help=true, descriptionKey="dbhelp", order=2)
    private boolean dbHelpRequired;
    @Parameter(names={"-l", "--license"}, help=true, descriptionKey="license", order=3)
    private boolean printLicense;
    @Parameter(names={"-debug", "--debug", "debug", "schemaspy.debug"}, descriptionKey="debug")
    private boolean debug = false;
    @Parameter(names={"-nohtml", "--no-html", "nohtml", "schemaspy.nohtml"}, descriptionKey="nohtml")
    private boolean nohtml = false;
    @Parameter(names={"-t", "--database-type", "database-type", "schemaspy.t", "schemaspy.database-type"}, descriptionKey="database-type")
    private String databaseType = "ora";
    @Parameter(names={"-db", "-database-name", "schemaspy.db", "schemaspy.database-name"}, descriptionKey="databaseName")
    private String databaseName;
    @Parameter(names={"-sso", "--single-sign-on", "schemaspy.sso", "schemaspy.single-sign-on"}, descriptionKey="sso")
    private boolean sso = false;
    @Parameter(names={"-u", "--user", "user", "schemaspy.u", "schemaspy.user"}, descriptionKey="user")
    private String user;
    @Parameter(names={"-s", "--schema", "schema", "schemaspy.s", "schemaspy.schema"}, descriptionKey="schema")
    private String schema;
    @Parameter(names={"-cat", "--catalog", "catalog", "schemaspy.cat", "schemaspy.catalog"}, descriptionKey="catalog")
    private String catalog;
    @Parameter(names={"-dp", "--driverPath", "driverPath", "schemaspy.dp", "schemaspy.driverPath"}, descriptionKey="driverPath")
    private String driverPath;
    @Parameter(names={"-o", "--outputDirectory", "outputDirectory", "schemaspy.o", "schemaspy.outputDirectory"}, descriptionKey="outputDirectory")
    private File outputDirectory;
    @Parameter(names={"-port", "--port", "port", "schemaspy.port"})
    private Integer port;
    @Parameter(names={"-vizjs", "schemaspy.vizjs"}, descriptionKey="vizjs", required=false)
    private boolean useVizJS;
    @Parameter(names={"-degree", "schemaspy.degree"}, descriptionKey="degree", required=false, validateValueWith={DegreeOfSeparationValidator.class})
    private int degreeOfSeparation = 2;

    public boolean isHelpRequired() {
        return this.helpRequired;
    }

    public boolean isDbHelpRequired() {
        return this.dbHelpRequired;
    }

    public boolean isPrintLicense() {
        return this.printLicense;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isHtmlDisabled() {
        return this.nohtml;
    }

    public boolean isHtmlEnabled() {
        return !this.nohtml;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isSingleSignOn() {
        return this.sso;
    }

    public String getUser() {
        return this.user;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Integer getPort() {
        return this.port;
    }

    public boolean useVizJS() {
        return this.useVizJS;
    }

    public int getDegreeOfSeparation() {
        return this.degreeOfSeparation;
    }
}

