/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.cli;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.schemaspy.Config;
import org.schemaspy.cli.CommandLineArguments;
import org.schemaspy.input.dbms.config.PropertiesResolver;
import org.schemaspy.util.DbSpecificConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommandLineArgumentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PropertiesResolver propertiesResolver = new PropertiesResolver();
    private final JCommander jCommander;
    private final CommandLineArguments arguments;
    private static final String[] requiredFields = new String[]{"outputDirectory"};

    public CommandLineArgumentParser(CommandLineArguments commandLineArguments, IDefaultProvider defaultProvider) {
        this.arguments = commandLineArguments;
        this.jCommander = JCommander.newBuilder().acceptUnknownOptions(true).programName("java -jar " + Config.getLoadedFromJar()).columnSize(120).defaultProvider(defaultProvider).build();
        this.jCommander.addObject((Object)this.arguments);
    }

    public CommandLineArguments parse(String ... localArgs) {
        this.jCommander.parse(localArgs);
        if (this.shouldValidate()) {
            this.validate(this.arguments);
        }
        return this.arguments;
    }

    private boolean shouldValidate() {
        List helpParameters = this.jCommander.getParameters().stream().filter(ParameterDescription::isHelp).collect(Collectors.toList());
        for (ParameterDescription parameterDescription : helpParameters) {
            if (!parameterDescription.isAssigned()) continue;
            return false;
        }
        return true;
    }

    private void validate(CommandLineArguments arguments) {
        List runtimeRequiredFields = CommandLineArgumentParser.computeRequiredFields((CommandLineArguments)arguments);
        ArrayList<String> missingFields = new ArrayList<String>();
        Map<String, ParameterDescription> fieldToParameterDescription = this.jCommander.getParameters().stream().collect(Collectors.toMap(parameterDescription -> parameterDescription.getParameterized().getName(), parameterDescription -> parameterDescription));
        for (String field : runtimeRequiredFields) {
            ParameterDescription parameterDescription2 = fieldToParameterDescription.get(field);
            if (!CommandLineArgumentParser.valueIsMissing((ParameterDescription)parameterDescription2)) continue;
            missingFields.add("[" + String.join((CharSequence)" | ", parameterDescription2.getParameter().names()) + "]");
        }
        if (!missingFields.isEmpty()) {
            String message = String.join((CharSequence)", ", missingFields);
            throw new ParameterException("The following " + (missingFields.size() == 1 ? "option is required: " : "options are required: ") + message);
        }
    }

    private static List<String> computeRequiredFields(CommandLineArguments arguments) {
        ArrayList<String> computedRequiredFields = new ArrayList<String>(Arrays.asList(requiredFields));
        if (!arguments.isSingleSignOn()) {
            computedRequiredFields.add("user");
        }
        return computedRequiredFields;
    }

    private static boolean valueIsMissing(ParameterDescription parameterDescription) {
        Object value = parameterDescription.getParameterized().get(parameterDescription.getObject());
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return Objects.isNull(value);
    }

    public void printUsage() {
        StringBuilder builder = new StringBuilder();
        this.jCommander.usage(builder);
        builder.append(System.lineSeparator());
        builder.append("Go to http://schemaspy.org for a complete list/description of additional parameters.");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("Sample usage using the default database type (implied -t ora):");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append(" java -jar schemaSpy.jar -db mydb -s myschema -u devuser -p password -o output");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        LOGGER.info("{}", (Object)builder);
    }

    public void printDatabaseTypesHelp() {
        String schemaspyJarFileName = Config.getLoadedFromJar();
        LOGGER.info("Built-in database types and their required connection parameters:");
        for (String type : Config.getBuiltInDatabaseTypes((String)schemaspyJarFileName)) {
            new DbSpecificConfig(type, propertiesResolver.getDbProperties(type)).dumpUsage();
        }
        LOGGER.info("You can use your own database types by specifying the filespec of a .properties file with -t.");
        LOGGER.info("Grab one out of {} and modify it to suit your needs.", (Object)schemaspyJarFileName);
    }

    public void printLicense() {
        ClassPathResource gpl = new ClassPathResource("COPYING");
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(gpl.getInputStream(), StandardCharsets.UTF_8));){
            bufferedReader.lines().forEachOrdered(arg_0 -> ((Logger)LOGGER).info(arg_0));
        }
        catch (IOException e) {
            LOGGER.error("Failed to read COPYING (GPL)", (Throwable)e);
        }
        ClassPathResource lgpl = new ClassPathResource("COPYING.LESSER");
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(lgpl.getInputStream(), StandardCharsets.UTF_8));){
            bufferedReader.lines().forEachOrdered(arg_0 -> ((Logger)LOGGER).info(arg_0));
        }
        catch (IOException e) {
            LOGGER.error("Failed to read COPYING.LESSER (LGPL)", (Throwable)e);
        }
    }
}

