/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.schemaspy.TableOrderer;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.Table;

/*
 * Exception performing whole class analysis ignored.
 */
public class TableOrderer {
    public List<Table> getTablesOrderedByRI(Collection<Table> tables, Collection<ForeignKeyConstraint> recursiveConstraints) {
        ArrayList heads = new ArrayList();
        ArrayList tails = new ArrayList();
        ArrayList<Table> remainingTables = new ArrayList<Table>(tables);
        List unattached = new ArrayList();
        TableOrderer.removeRemotesAndUnattached(remainingTables, unattached);
        unattached = TableOrderer.sortTrimmedLevel(unattached);
        boolean prunedNonReals = false;
        while (!remainingTables.isEmpty()) {
            int tablesLeft = remainingTables.size();
            tails.addAll(0, TableOrderer.trimLeaves(remainingTables));
            heads.addAll(TableOrderer.trimRoots(remainingTables));
            if (tablesLeft != remainingTables.size()) continue;
            if (!prunedNonReals) {
                for (Table table : remainingTables) {
                    table.removeNonRealForeignKeys();
                }
                prunedNonReals = true;
                continue;
            }
            boolean foundSimpleRecursion = TableOrderer.removeSelfReferencingConstraints(remainingTables, recursiveConstraints);
            TableOrderer.removeAForeignKeyConstraint(recursiveConstraints, remainingTables, (boolean)foundSimpleRecursion);
        }
        ArrayList<Table> ordered = new ArrayList<Table>(heads.size() + tails.size());
        ordered.addAll(heads);
        ordered.addAll(tails);
        ordered.addAll(unattached);
        return ordered;
    }

    private static void removeRemotesAndUnattached(List<Table> remainingTables, List<Table> unattached) {
        Iterator<Table> iter = remainingTables.iterator();
        while (iter.hasNext()) {
            Table table = iter.next();
            if (table.isRemote()) {
                table.unlinkParents();
                table.unlinkChildren();
                iter.remove();
                continue;
            }
            if (!table.isLeaf() || !table.isRoot()) continue;
            unattached.add(table);
            iter.remove();
        }
    }

    private static List<Table> trimLeaves(List<Table> tables) {
        List<Table> leaves = new ArrayList();
        Iterator<Object> iter = tables.iterator();
        while (iter.hasNext()) {
            Table leaf = iter.next();
            if (!leaf.isLeaf()) continue;
            leaves.add(leaf);
            iter.remove();
        }
        leaves = TableOrderer.sortTrimmedLevel(leaves);
        iter = leaves.iterator();
        while (iter.hasNext()) {
            ((Table)iter.next()).unlinkParents();
        }
        return leaves;
    }

    private static List<Table> trimRoots(List<Table> tables) {
        List<Table> roots = new ArrayList();
        Iterator<Object> iter = tables.iterator();
        while (iter.hasNext()) {
            Table root = iter.next();
            if (!root.isRoot()) continue;
            roots.add(root);
            iter.remove();
        }
        roots = TableOrderer.sortTrimmedLevel(roots);
        iter = roots.iterator();
        while (iter.hasNext()) {
            ((Table)iter.next()).unlinkChildren();
        }
        return roots;
    }

    private static List<Table> sortTrimmedLevel(List<Table> tables) {
        TreeSet<Table> sorter = new TreeSet<Table>((Comparator<Table>)new TrimComparator());
        sorter.addAll(tables);
        return new ArrayList<Table>(sorter);
    }

    private static boolean removeSelfReferencingConstraints(List<Table> remainingTables, Collection<ForeignKeyConstraint> recursiveConstraints) {
        boolean foundSimpleRecursion = false;
        for (Table potentialRecursiveTable : remainingTables) {
            ForeignKeyConstraint recursiveConstraint = potentialRecursiveTable.removeSelfReferencingConstraint();
            if (recursiveConstraint == null) continue;
            recursiveConstraints.add(recursiveConstraint);
            foundSimpleRecursion = true;
        }
        return foundSimpleRecursion;
    }

    private static void removeAForeignKeyConstraint(Collection<ForeignKeyConstraint> recursiveConstraints, List<Table> remainingTables, boolean foundSimpleRecursion) {
        if (!foundSimpleRecursion) {
            TreeSet<Table> byParentChildDelta = new TreeSet<Table>((t1, t2) -> {
                int rc = Math.abs(t2.getNumChildren() - t2.getNumParents()) - Math.abs(t1.getNumChildren() - t1.getNumParents());
                if (rc == 0) {
                    rc = t1.compareTo(t2);
                }
                return rc;
            });
            byParentChildDelta.addAll(remainingTables);
            Table recursiveTable = (Table)byParentChildDelta.iterator().next();
            ForeignKeyConstraint removedConstraint = recursiveTable.removeAForeignKeyConstraint();
            recursiveConstraints.add(removedConstraint);
        }
    }
}

