/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.schemaspy.Config;
import org.schemaspy.DbAnalyzer;
import org.schemaspy.DotConfigUsingConfig;
import org.schemaspy.TableOrderer;
import org.schemaspy.analyzer.ImpliedConstraintsFinder;
import org.schemaspy.cli.CommandLineArguments;
import org.schemaspy.input.dbms.CatalogResolver;
import org.schemaspy.input.dbms.DbDriverLoader;
import org.schemaspy.input.dbms.SchemaResolver;
import org.schemaspy.input.dbms.service.DatabaseService;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.input.dbms.xml.SchemaMeta;
import org.schemaspy.model.ConsoleProgressListener;
import org.schemaspy.model.Database;
import org.schemaspy.model.DbmsMeta;
import org.schemaspy.model.EmptySchemaException;
import org.schemaspy.model.ProgressListener;
import org.schemaspy.model.Routine;
import org.schemaspy.model.Table;
import org.schemaspy.output.OutputException;
import org.schemaspy.output.OutputProducer;
import org.schemaspy.output.diagram.DiagramFactory;
import org.schemaspy.output.diagram.DiagramProducer;
import org.schemaspy.output.diagram.graphviz.GraphvizConfig;
import org.schemaspy.output.diagram.graphviz.GraphvizDot;
import org.schemaspy.output.diagram.vizjs.VizJSDot;
import org.schemaspy.output.dot.DotConfig;
import org.schemaspy.output.dot.schemaspy.DotFormatter;
import org.schemaspy.output.html.mustache.diagrams.MustacheDiagramFactory;
import org.schemaspy.output.html.mustache.diagrams.MustacheOrphanDiagramFactory;
import org.schemaspy.output.html.mustache.diagrams.MustacheSummaryDiagramFactory;
import org.schemaspy.output.html.mustache.diagrams.MustacheSummaryDiagramResults;
import org.schemaspy.output.html.mustache.diagrams.MustacheTableDiagramFactory;
import org.schemaspy.output.xml.dom.XmlProducerUsingDOM;
import org.schemaspy.util.ManifestUtils;
import org.schemaspy.util.Markdown;
import org.schemaspy.util.ResourceWriter;
import org.schemaspy.util.Writers;
import org.schemaspy.view.HtmlAnomaliesPage;
import org.schemaspy.view.HtmlColumnsPage;
import org.schemaspy.view.HtmlConfig;
import org.schemaspy.view.HtmlConstraintsPage;
import org.schemaspy.view.HtmlMainIndexPage;
import org.schemaspy.view.HtmlMultipleSchemasIndexPage;
import org.schemaspy.view.HtmlOrphansPage;
import org.schemaspy.view.HtmlRelationshipsPage;
import org.schemaspy.view.HtmlRoutinePage;
import org.schemaspy.view.HtmlRoutinesPage;
import org.schemaspy.view.HtmlTablePage;
import org.schemaspy.view.MustacheCatalog;
import org.schemaspy.view.MustacheCompiler;
import org.schemaspy.view.MustacheSchema;
import org.schemaspy.view.SqlAnalyzer;
import org.schemaspy.view.TextFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int SECONDS_IN_MS = 1000;
    private static final String DOT_HTML = ".html";
    private static final String INDEX_DOT_HTML = "index.html";
    private final SqlService sqlService;
    private final DatabaseService databaseService;
    private final CommandLineArguments commandLineArguments;
    private final List<OutputProducer> outputProducers = new ArrayList();

    public SchemaAnalyzer(SqlService sqlService, DatabaseService databaseService, CommandLineArguments commandLineArguments) {
        this.sqlService = Objects.requireNonNull(sqlService);
        this.databaseService = Objects.requireNonNull(databaseService);
        this.commandLineArguments = Objects.requireNonNull(commandLineArguments);
        this.addOutputProducer((OutputProducer)new XmlProducerUsingDOM());
    }

    public SchemaAnalyzer addOutputProducer(OutputProducer outputProducer) {
        this.outputProducers.add(outputProducer);
        return this;
    }

    public Database analyze(Config config) throws SQLException, IOException {
        boolean render = config.isHtmlGenerationEnabled();
        ConsoleProgressListener progressListener = new ConsoleProgressListener(render, this.commandLineArguments);
        List schemas = config.getSchemas();
        if (schemas != null || config.isEvaluateAllEnabled()) {
            return this.analyzeMultipleSchemas(config, (ProgressListener)progressListener);
        }
        File outputDirectory = this.commandLineArguments.getOutputDirectory();
        Objects.requireNonNull(outputDirectory);
        String schema = this.commandLineArguments.getSchema();
        return this.analyze(schema, config, outputDirectory, (ProgressListener)progressListener);
    }

    public Database analyzeMultipleSchemas(Config config, ProgressListener progressListener) throws SQLException, IOException {
        try {
            List args = config.asList();
            args.remove("-schemas");
            args.remove("-schemata");
            List schemas = config.getSchemas();
            Database db = null;
            String schemaSpec = config.getSchemaSpec();
            Connection connection = SchemaAnalyzer.getConnection((Config)config);
            DatabaseMetaData meta = connection.getMetaData();
            if (schemas == null || config.isEvaluateAllEnabled()) {
                if (schemaSpec == null) {
                    schemaSpec = ".*";
                }
                LOGGER.info("Analyzing schemas that match regular expression '{}'. (use -schemaSpec on command line or in .properties to exclude other schemas)", (Object)schemaSpec);
                schemas = DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta, (String)schemaSpec, (boolean)false);
                if (schemas.isEmpty()) {
                    schemas = DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta, (String)schemaSpec, (boolean)true);
                }
                if (schemas.isEmpty()) {
                    schemas.add(config.getUser());
                }
            }
            LOGGER.info("Analyzing schemas: {}{}", (Object)System.lineSeparator(), (Object)schemas.stream().collect(Collectors.joining(System.lineSeparator())));
            String dbName = config.getDb();
            File outputDir = this.commandLineArguments.getOutputDirectory();
            config.setOneOfMultipleSchemas(true);
            ArrayList<MustacheSchema> mustacheSchemas = new ArrayList<MustacheSchema>();
            MustacheCatalog mustacheCatalog = null;
            for (String schema : schemas) {
                config.setSchemas(null);
                config.setEvaluateAllEnabled(false);
                if (dbName == null) {
                    config.setDb(schema);
                } else {
                    config.setSchema(schema);
                }
                LOGGER.info("Analyzing {}", (Object)schema);
                File outputDirForSchema = new File(outputDir, schema);
                db = this.analyze(schema, config, outputDirForSchema, progressListener);
                if (db == null) {
                    return null;
                }
                mustacheSchemas.add(new MustacheSchema(db.getSchema(), ""));
                mustacheCatalog = new MustacheCatalog(db.getCatalog(), "");
            }
            SchemaAnalyzer.prepareLayoutFiles((File)outputDir);
            MustacheCompiler mustacheCompiler = new MustacheCompiler(dbName, (HtmlConfig)config);
            HtmlMultipleSchemasIndexPage htmlMultipleSchemasIndexPage = new HtmlMultipleSchemasIndexPage(mustacheCompiler);
            try (PrintWriter writer = Writers.newPrintWriter((File)outputDir.toPath().resolve("index.html").toFile());){
                htmlMultipleSchemasIndexPage.write(mustacheCatalog, mustacheSchemas, config.getDescription(), SchemaAnalyzer.getDatabaseProduct((DatabaseMetaData)meta), (Writer)writer);
            }
            return db;
        }
        catch (Config.MissingRequiredParameterException missingParam) {
            config.dumpUsage(missingParam.getMessage(), missingParam.isDbTypeSpecific());
            return null;
        }
    }

    private static String getDatabaseProduct(DatabaseMetaData meta) {
        try {
            return meta.getDatabaseProductName() + " - " + meta.getDatabaseProductVersion();
        }
        catch (SQLException exc) {
            return "";
        }
    }

    public Database analyze(String schema, Config config, File outputDir, ProgressListener progressListener) throws SQLException, IOException {
        try {
            SchemaMeta schemaMeta;
            LOGGER.info("Starting schema analysis");
            FileUtils.forceMkdir((File)outputDir);
            String dbName = config.getDb();
            String catalog = this.commandLineArguments.getCatalog();
            DatabaseMetaData databaseMetaData = this.sqlService.connect(config);
            DbmsMeta dbmsMeta = this.sqlService.getDbmsMeta();
            LOGGER.debug("supportsSchemasInTableDefinitions: {}", (Object)databaseMetaData.supportsSchemasInTableDefinitions());
            LOGGER.debug("supportsCatalogsInTableDefinitions: {}", (Object)databaseMetaData.supportsCatalogsInTableDefinitions());
            catalog = new CatalogResolver(databaseMetaData).resolveCatalog(catalog);
            schema = new SchemaResolver(databaseMetaData).resolveSchema(schema);
            SchemaMeta schemaMeta2 = schemaMeta = config.getMeta() == null ? null : new SchemaMeta(config.getMeta(), dbName, schema);
            if (config.isHtmlGenerationEnabled()) {
                FileUtils.forceMkdir((File)new File(outputDir, "tables"));
                FileUtils.forceMkdir((File)new File(outputDir, "diagrams/summary"));
                LOGGER.info("Connected to {} - {}", (Object)databaseMetaData.getDatabaseProductName(), (Object)databaseMetaData.getDatabaseProductVersion());
                if (schemaMeta != null && schemaMeta.getFile() != null) {
                    LOGGER.info("Using additional metadata from {}", (Object)schemaMeta.getFile());
                }
            }
            Database db = new Database(dbmsMeta, dbName, catalog, schema);
            this.databaseService.gatherSchemaDetails(config, db, schemaMeta, progressListener);
            ArrayList tables = new ArrayList(db.getTables());
            tables.addAll(db.getViews());
            if (tables.isEmpty()) {
                SchemaAnalyzer.dumpNoTablesMessage((String)schema, (String)config.getUser(), (DatabaseMetaData)databaseMetaData, (config.getTableInclusions() != null ? 1 : 0) != 0);
                if (!config.isOneOfMultipleSchemas()) {
                    throw new EmptySchemaException();
                }
            }
            long duration = progressListener.startedGraphingSummaries();
            if (config.isHtmlGenerationEnabled()) {
                this.generateHtmlDoc(config, this.commandLineArguments.useVizJS(), progressListener, outputDir, db, duration, tables);
            }
            this.outputProducers.forEach(outputProducer -> {
                try {
                    outputProducer.generate(db, outputDir);
                }
                catch (OutputException oe) {
                    if (config.isOneOfMultipleSchemas()) {
                        LOGGER.warn("Failed to produce output", (Throwable)oe);
                    }
                    throw oe;
                }
            });
            ArrayList recursiveConstraints = new ArrayList();
            TableOrderer orderer = new TableOrderer();
            List orderedTables = orderer.getTablesOrderedByRI(db.getTables(), recursiveConstraints);
            SchemaAnalyzer.writeOrders((File)outputDir, (List)orderedTables);
            duration = progressListener.finishedGatheringDetails();
            long overallDuration = progressListener.finished(tables, config);
            if (config.isHtmlGenerationEnabled()) {
                LOGGER.info("Wrote table details in {} seconds", (Object)(duration / 1000L));
                LOGGER.info("Wrote relationship details of {} tables/views to directory '{}' in {} seconds.", new Object[]{tables.size(), outputDir, overallDuration / 1000L});
                LOGGER.info("View the results by opening {}", (Object)new File(outputDir, "index.html"));
            }
            return db;
        }
        catch (Config.MissingRequiredParameterException missingParam) {
            config.dumpUsage(missingParam.getMessage(), missingParam.isDbTypeSpecific());
            return null;
        }
    }

    private static void writeOrders(File outputDir, List<Table> orderedTables) throws IOException {
        try (PrintWriter out = Writers.newPrintWriter((File)new File(outputDir, "insertionOrder.txt"));){
            TextFormatter.getInstance().write(orderedTables, false, out);
        }
        Collections.reverse(orderedTables);
        out = Writers.newPrintWriter((File)new File(outputDir, "deletionOrder.txt"));
        var3_3 = null;
        try {
            TextFormatter.getInstance().write(orderedTables, false, out);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var3_3 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    private void generateHtmlDoc(Config config, boolean useVizJS, ProgressListener progressListener, File outputDir, Database db, long duration, Collection<Table> tables) throws IOException {
        LOGGER.info("Gathered schema details in {} seconds", (Object)(duration / 1000L));
        LOGGER.info("Writing/graphing summary");
        SchemaAnalyzer.markDownRegistryPages(tables);
        SchemaAnalyzer.prepareLayoutFiles((File)outputDir);
        DiagramFactory diagramFactory = useVizJS ? new DiagramFactory((DiagramProducer)new VizJSDot(), outputDir) : new DiagramFactory((DiagramProducer)new GraphvizDot((GraphvizConfig)config), outputDir);
        Path htmlInfoFile = outputDir.toPath().resolve("info-html.txt");
        Files.deleteIfExists(htmlInfoFile);
        SchemaAnalyzer.writeInfo((String)"date", (String)ZonedDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssZ")), (Path)htmlInfoFile);
        SchemaAnalyzer.writeInfo((String)"os", (String)(System.getProperty("os.name") + " " + System.getProperty("os.version")), (Path)htmlInfoFile);
        SchemaAnalyzer.writeInfo((String)"schemaspy-version", (String)ManifestUtils.getImplementationVersion(), (Path)htmlInfoFile);
        SchemaAnalyzer.writeInfo((String)"schemaspy-build", (String)ManifestUtils.getImplementationBuild(), (Path)htmlInfoFile);
        SchemaAnalyzer.writeInfo((String)"diagramImplementation", (String)diagramFactory.getImplementationDetails(), (Path)htmlInfoFile);
        progressListener.graphingSummaryProgressed();
        boolean showDetailedTables = tables.size() <= config.getMaxDetailedTables();
        boolean includeImpliedConstraints = config.isImpliedConstraintsEnabled();
        if (config.isRailsEnabled()) {
            DbAnalyzer.getRailsConstraints((Map)db.getTablesMap());
        }
        DotConfigUsingConfig dotConfig = new DotConfigUsingConfig(config, "svg".equalsIgnoreCase(diagramFactory.getDiagramFormat()));
        DotFormatter dotProducer = new DotFormatter((DotConfig)dotConfig);
        MustacheDiagramFactory mustacheDiagramFactory = new MustacheDiagramFactory(diagramFactory);
        ImpliedConstraintsFinder impliedConstraintsFinder = new ImpliedConstraintsFinder();
        MustacheSummaryDiagramFactory mustacheSummaryDiagramFactory = new MustacheSummaryDiagramFactory(dotProducer, mustacheDiagramFactory, impliedConstraintsFinder, outputDir);
        MustacheSummaryDiagramResults results = mustacheSummaryDiagramFactory.generateSummaryDiagrams(db, tables, includeImpliedConstraints, showDetailedTables, progressListener);
        results.getOutputExceptions().stream().forEachOrdered(exception -> LOGGER.error("RelationShipDiagramError", (Throwable)exception));
        MustacheCompiler mustacheCompiler = new MustacheCompiler(db.getName(), (HtmlConfig)config);
        HtmlRelationshipsPage htmlRelationshipsPage = new HtmlRelationshipsPage(mustacheCompiler);
        try (PrintWriter writer = Writers.newPrintWriter((File)outputDir.toPath().resolve("relationships.html").toFile());){
            htmlRelationshipsPage.write(results, (Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        List orphans = DbAnalyzer.getOrphans(tables);
        MustacheOrphanDiagramFactory mustacheOrphanDiagramFactory = new MustacheOrphanDiagramFactory(dotProducer, mustacheDiagramFactory, outputDir);
        List orphanDiagrams = mustacheOrphanDiagramFactory.generateOrphanDiagrams(orphans);
        HtmlOrphansPage htmlOrphansPage = new HtmlOrphansPage(mustacheCompiler);
        try (PrintWriter writer = Writers.newPrintWriter((File)outputDir.toPath().resolve("orphans.html").toFile());){
            htmlOrphansPage.write(orphanDiagrams, orphanDiagrams.size() == orphans.size(), (Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        HtmlMainIndexPage htmlMainIndexPage = new HtmlMainIndexPage(mustacheCompiler, config.getDescription());
        try (PrintWriter writer = Writers.newPrintWriter((File)outputDir.toPath().resolve("index.html").toFile());){
            htmlMainIndexPage.write(db, tables, results.getImpliedConstraints(), (Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        List constraints = DbAnalyzer.getForeignKeyConstraints(tables);
        HtmlConstraintsPage htmlConstraintsPage = new HtmlConstraintsPage(mustacheCompiler);
        try (PrintWriter writer = Writers.newPrintWriter((File)outputDir.toPath().resolve("constraints.html").toFile());){
            htmlConstraintsPage.write(constraints, tables, (Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        HtmlAnomaliesPage htmlAnomaliesPage = new HtmlAnomaliesPage(mustacheCompiler);
        try (PrintWriter writer = Writers.newPrintWriter((File)outputDir.toPath().resolve("anomalies.html").toFile());){
            htmlAnomaliesPage.write(tables, results.getImpliedConstraints(), (Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        HtmlColumnsPage htmlColumnsPage = new HtmlColumnsPage(mustacheCompiler);
        try (PrintWriter writer = Writers.newPrintWriter((File)outputDir.toPath().resolve("columns.html").toFile());){
            htmlColumnsPage.write(tables, (Writer)writer);
        }
        progressListener.graphingSummaryProgressed();
        HtmlRoutinesPage htmlRoutinesPage = new HtmlRoutinesPage(mustacheCompiler);
        PrintWriter writer = Writers.newPrintWriter((File)outputDir.toPath().resolve("routines.html").toFile());
        Object object = null;
        try {
            htmlRoutinesPage.write(db.getRoutines(), (Writer)writer);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (object != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((Writer)writer).close();
                }
            }
        }
        HtmlRoutinePage htmlRoutinePage = new HtmlRoutinePage(mustacheCompiler);
        for (Routine routine : db.getRoutines()) {
            PrintWriter writer2 = Writers.newPrintWriter((File)outputDir.toPath().resolve("routines").resolve(routine.getName() + ".html").toFile());
            Object object2 = null;
            try {
                htmlRoutinePage.write(routine, (Writer)writer2);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (writer2 == null) continue;
                if (object2 != null) {
                    try {
                        ((Writer)writer2).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                    continue;
                }
                ((Writer)writer2).close();
            }
        }
        duration = progressListener.startedGraphingDetails();
        LOGGER.info("Completed summary in {} seconds", (Object)(duration / 1000L));
        LOGGER.info("Writing/diagramming details");
        SqlAnalyzer sqlAnalyzer = new SqlAnalyzer(db.getDbmsMeta().getAllKeywords(), db.getTables(), db.getViews());
        MustacheTableDiagramFactory mustacheTableDiagramFactory = new MustacheTableDiagramFactory(dotProducer, mustacheDiagramFactory, outputDir, this.commandLineArguments.getDegreeOfSeparation());
        HtmlTablePage htmlTablePage = new HtmlTablePage(mustacheCompiler, sqlAnalyzer);
        for (Table table : tables) {
            List mustacheTableDiagrams = mustacheTableDiagramFactory.generateTableDiagrams(table, results.getStats());
            progressListener.graphingDetailsProgressed(table);
            LOGGER.debug("Writing details of {}", (Object)table.getName());
            PrintWriter writer3 = Writers.newPrintWriter((File)outputDir.toPath().resolve("tables").resolve(table.getName() + ".html").toFile());
            Throwable throwable = null;
            try {
                htmlTablePage.write(table, mustacheTableDiagrams, (Writer)writer3);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer3 == null) continue;
                if (throwable != null) {
                    try {
                        ((Writer)writer3).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Writer)writer3).close();
            }
        }
    }

    private static void markDownRegistryPages(Collection<Table> tables) {
        tables.stream().filter(table -> !table.isLogical()).forEach(table -> {
            String tablePath = "tables/" + table.getName() + ".html";
            Markdown.registryPage((String)table.getName(), (String)tablePath);
        });
    }

    private static void prepareLayoutFiles(File outputDir) throws IOException {
        URL url = null;
        Enumeration<URL> possibleResources = SchemaAnalyzer.class.getClassLoader().getResources("layout");
        while (possibleResources.hasMoreElements() && Objects.isNull(url)) {
            URL possibleResource = possibleResources.nextElement();
            if (possibleResource.getPath().contains("test-classes")) continue;
            url = possibleResource;
        }
        IOFileFilter notHtmlFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".html"));
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{notHtmlFilter});
        ResourceWriter.copyResources((URL)url, (File)outputDir, (FileFilter)filter);
    }

    private static void writeInfo(String key, String value, Path infoFile) {
        try {
            Files.write(infoFile, (key + "=" + value + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write '{}', to '{}'", new Object[]{key + "=" + value, infoFile, e});
        }
    }

    private static Connection getConnection(Config config) throws IOException {
        DbDriverLoader driverLoader = new DbDriverLoader();
        return driverLoader.getConnection(config);
    }

    private static void dumpNoTablesMessage(String schema, String user, DatabaseMetaData meta, boolean specifiedInclusions) throws SQLException {
        List schemas;
        LOGGER.warn("No tables or views were found in schema '{}'.", (Object)schema);
        try {
            schemas = DbAnalyzer.getSchemas((DatabaseMetaData)meta);
        }
        catch (RuntimeException | SQLException exc) {
            LOGGER.error("The user you specified '{}' might not have rights to read the database metadata.", (Object)user, (Object)exc);
            return;
        }
        if (Objects.isNull(schemas)) {
            LOGGER.error("Failed to retrieve any schemas");
        } else if (schemas.contains(schema)) {
            LOGGER.error("The schema exists in the database, but the user you specified '{}'might not have rights to read its contents.", (Object)user);
            if (specifiedInclusions) {
                LOGGER.error("Another possibility is that the regular expression that you specified for what to include (via -i) didn't match any tables.");
            }
        } else {
            LOGGER.error("The schema '{}' could not be read/found, schema is specified using the -s option.Make sure user '{}' has the correct privileges to read the schema.Also not that schema names are usually case sensitive.", (Object)schema, (Object)user);
            LOGGER.info("Available schemas(Some of these may be user or system schemas):{}{}", (Object)System.lineSeparator(), (Object)schemas.stream().collect(Collectors.joining(System.lineSeparator())));
            List populatedSchemas = DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta);
            if (populatedSchemas.isEmpty()) {
                LOGGER.error("Unable to determine if any of the schemas contain tables/views");
            } else {
                LOGGER.info("Schemas with tables/views visible to '{}':{}{}", new Object[]{user, System.lineSeparator(), populatedSchemas.stream().collect(Collectors.joining(System.lineSeparator()))});
            }
        }
    }
}

