/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.schemaspy.Config;
import org.schemaspy.input.dbms.config.PropertiesResolver;
import org.schemaspy.model.InvalidConfigurationException;
import org.schemaspy.output.diagram.graphviz.GraphvizConfig;
import org.schemaspy.util.DbSpecificConfig;
import org.schemaspy.view.HtmlConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Config
implements HtmlConfig,
GraphvizConfig {
    private static final int DEFAULT_FONT_SIZE = 11;
    private static final int DEFAULT_TABLE_DETAILS_THRESHOLD = 300;
    private static final Pattern DBTYPE_PATTERN = Pattern.compile(".*org/schemaspy/types/(.*)\\.properties");
    private static Config instance;
    private final List<String> options;
    private Map<String, String> dbSpecificOptions;
    private Map<String, String> originalDbSpecificOptions;
    private boolean helpRequired;
    private boolean dbHelpRequired;
    private String graphvizDir;
    private String dbType;
    private String schema;
    private List<String> schemas;
    private boolean oneOfMultipleSchemas;
    private String user;
    private Boolean singleSignOn;
    private String password;
    private Boolean promptForPassword;
    private String db;
    private String host;
    private Integer port;
    private String meta;
    private Boolean exportedKeysEnabled;
    private String templateDirectory;
    private Pattern tableInclusions;
    private Pattern tableExclusions;
    private Pattern columnExclusions;
    private Pattern indirectColumnExclusions;
    private String userConnectionPropertiesFile;
    private Properties userConnectionProperties;
    private Integer maxDbThreads;
    private Integer maxDetailedTables;
    private String driverPath;
    private String css;
    private String font;
    private Integer fontSize;
    private String description;
    private PropertiesResolver propertiesResolver = new PropertiesResolver();
    private Properties dbProperties;
    private Boolean generateHtml;
    private Boolean includeImpliedConstraints;
    private Boolean rankDirBugEnabled;
    private Boolean numRowsEnabled;
    private Boolean viewsEnabled;
    private Boolean railsEnabled;
    private Boolean evaluateAll;
    private Boolean highQuality;
    private String imageFormat;
    private String renderer;
    private Boolean paginationEnabled;
    @Deprecated
    private Boolean loadJDBCJarsEnabled = false;
    private String schemaSpec;
    private boolean hasOrphans;
    private boolean hasRoutines;
    private boolean populating;
    public static final String DOT_CHARSET = "UTF-8";
    private static final String ESCAPED_EQUALS = "\\=";
    private static final String DEFAULT_TABLE_INCLUSION = ".*";
    private static final String DEFAULT_TABLE_EXCLUSION = ".*\\$.*";
    private static final String DEFAULT_COLUMN_EXCLUSION = "[^.]";
    private static final String DEFAULT_PROPERTIES_FILE = "schemaspy.properties";
    private Properties schemaspyProperties = new Properties();
    private static final Logger LOGGER;

    public Config() {
        if (instance == null) {
            Config.setInstance((Config)this);
        }
        this.options = new ArrayList();
    }

    public Config(String ... argv) {
        Config.setInstance((Config)this);
        this.options = this.fixupArgs(Arrays.asList(argv));
        this.helpRequired = this.options.remove("-?") || this.options.remove("/?") || this.options.remove("?") || this.options.remove("-h") || this.options.remove("-help") || this.options.remove("--help");
        this.dbHelpRequired = this.options.remove("-dbHelp") || this.options.remove("-dbhelp");
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public static void setInstance(Config config) {
        instance = config;
    }

    public boolean isHtmlGenerationEnabled() {
        if (this.generateHtml == null) {
            this.generateHtml = !this.options.remove("-nohtml");
        }
        return this.generateHtml;
    }

    public boolean isImpliedConstraintsEnabled() {
        if (this.includeImpliedConstraints == null) {
            this.includeImpliedConstraints = !this.options.remove("-noimplied");
        }
        return this.includeImpliedConstraints;
    }

    public void setGraphvizDir(String graphvizDir) {
        if (graphvizDir.endsWith("\"")) {
            graphvizDir = graphvizDir.substring(0, graphvizDir.length() - 1);
        }
        this.graphvizDir = new File(graphvizDir).toString();
    }

    public String getGraphvizDir() {
        String gv;
        if (this.graphvizDir == null && (gv = this.pullParam("-gv")) != null) {
            this.setGraphvizDir(gv);
        }
        return this.graphvizDir;
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }

    public String getMeta() {
        if (this.meta == null) {
            this.meta = this.pullParam("-meta");
        }
        return this.meta;
    }

    public boolean isExportedKeysEnabled() {
        if (Objects.isNull(this.exportedKeysEnabled)) {
            this.exportedKeysEnabled = !this.options.remove("-noexportedkeys");
        }
        return this.exportedKeysEnabled;
    }

    public String getTemplateDirectory() {
        if (this.templateDirectory == null) {
            this.templateDirectory = this.pullParam("-template");
            if (this.templateDirectory == null) {
                this.templateDirectory = "layout";
            }
        }
        return this.templateDirectory;
    }

    @Deprecated
    public String getDbType() {
        if (this.dbType == null) {
            this.dbType = this.pullParam("-t");
            if (this.dbType == null) {
                this.dbType = "ora";
            }
        }
        return this.dbType;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getDb() {
        if (this.db == null) {
            this.db = this.pullParam("-db");
        }
        return this.db;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Deprecated
    public String getSchema() {
        if (this.schema == null) {
            this.schema = this.pullParam("-s");
        }
        return this.schema;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = this.pullParam("-host");
        }
        return this.host;
    }

    public Integer getPort() {
        String portAsString;
        if (this.port == null && Config.hasText((String)(portAsString = this.pullParam("-port")))) {
            try {
                this.port = Integer.valueOf(portAsString);
            }
            catch (NumberFormatException notSpecified) {
                LOGGER.warn(notSpecified.getMessage(), (Throwable)notSpecified);
            }
        }
        return this.port;
    }

    private static boolean hasText(String string) {
        return Objects.nonNull(string) && !string.trim().isEmpty();
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        if (this.user == null) {
            this.user = !this.isSingleSignOn() ? this.pullRequiredParam("-u") : this.pullParam("-u");
        }
        return this.user;
    }

    public void setSingleSignOn(boolean enabled) {
        this.singleSignOn = enabled;
    }

    public boolean isSingleSignOn() {
        if (this.singleSignOn == null) {
            this.singleSignOn = this.options.remove("-sso");
        }
        return this.singleSignOn;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = this.pullParam("-p");
        }
        if (this.password == null && this.isPromptForPasswordEnabled()) {
            Console console = System.console();
            if (Objects.isNull(console)) {
                LOGGER.error("No console found for password input");
            } else {
                this.password = new String(console.readPassword("Password: ", new Object[0]));
            }
        }
        if (this.password == null) {
            this.password = System.getenv("schemaspy.pw");
        }
        return this.password;
    }

    public void setPromptForPasswordEnabled(boolean promptForPassword) {
        this.promptForPassword = promptForPassword;
    }

    public boolean isPromptForPasswordEnabled() {
        if (this.promptForPassword == null) {
            this.promptForPassword = this.options.remove("-pfp");
        }
        return this.promptForPassword;
    }

    public void setMaxDetailedTabled(int maxDetailedTables) {
        this.maxDetailedTables = maxDetailedTables;
    }

    public int getMaxDetailedTables() {
        if (this.maxDetailedTables == null) {
            int max = 300;
            String param = this.pullParam("-maxdet");
            if (param != null) {
                try {
                    max = Integer.parseInt(param);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
            this.maxDetailedTables = max;
        }
        return this.maxDetailedTables;
    }

    public String getConnectionPropertiesFile() {
        return this.userConnectionPropertiesFile;
    }

    public void setConnectionPropertiesFile(String propertiesFilename) throws IOException {
        if (this.userConnectionProperties == null) {
            this.userConnectionProperties = new Properties();
        }
        this.userConnectionProperties.load(new FileInputStream(propertiesFilename));
        this.userConnectionPropertiesFile = propertiesFilename;
    }

    public Properties getConnectionProperties() throws IOException {
        if (this.userConnectionProperties == null) {
            String props = this.pullParam("-connprops");
            if (props != null) {
                if (props.contains("\\=")) {
                    this.setConnectionProperties(props);
                } else {
                    this.setConnectionPropertiesFile(props);
                }
            } else {
                this.userConnectionProperties = new Properties();
            }
        }
        return this.userConnectionProperties;
    }

    public void setConnectionProperties(String properties) {
        this.userConnectionProperties = new Properties();
        StringTokenizer tokenizer = new StringTokenizer(properties, ";");
        while (tokenizer.hasMoreElements()) {
            String pair = tokenizer.nextToken();
            int index = pair.indexOf("\\=");
            if (index == -1) continue;
            String key = pair.substring(0, index);
            String value = pair.substring(index + "\\=".length());
            this.userConnectionProperties.put(key, value);
        }
    }

    public void setDriverPath(String driverPath) {
        this.driverPath = driverPath;
    }

    public String getDriverPath() {
        if (this.driverPath == null) {
            this.driverPath = this.pullParam("-dp");
        }
        if (this.driverPath == null) {
            this.driverPath = this.pullParam("-cp");
        }
        return this.driverPath;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public String getCss() {
        if (this.css == null) {
            this.css = this.pullParam("-css");
            if (this.css == null) {
                this.css = "schemaSpy.css";
            }
        }
        return this.css;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public String getFont() {
        if (this.font == null) {
            this.font = this.pullParam("-font");
            if (this.font == null) {
                this.font = "Helvetica";
            }
        }
        return this.font;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getFontSize() {
        if (this.fontSize == null) {
            int size = 11;
            String param = this.pullParam("-fontsize");
            if (param != null) {
                try {
                    size = Integer.parseInt(param);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
            this.fontSize = size;
        }
        return this.fontSize;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.pullParam("-desc");
        }
        return this.description;
    }

    public void setMaxDbThreads(int maxDbThreads) {
        this.maxDbThreads = maxDbThreads;
    }

    public int getMaxDbThreads() {
        if (this.maxDbThreads == null) {
            Properties properties = this.getDbProperties();
            int defaultMax = 15;
            int max = 15;
            String threads = properties.getProperty("dbThreads");
            if (threads == null) {
                threads = properties.getProperty("dbthreads");
            }
            if (threads != null) {
                max = Integer.parseInt(threads);
            }
            if ((threads = this.pullParam("-dbThreads")) == null) {
                threads = this.pullParam("-dbthreads");
            }
            if (threads != null) {
                max = Integer.parseInt(threads);
            }
            if (max < 0) {
                max = 15;
            } else if (max == 0) {
                max = 1;
            }
            this.maxDbThreads = max;
        }
        return this.maxDbThreads;
    }

    public void setRankDirBugEnabled(boolean enabled) {
        this.rankDirBugEnabled = enabled;
    }

    public boolean isRankDirBugEnabled() {
        if (this.rankDirBugEnabled == null) {
            this.rankDirBugEnabled = this.options.remove("-rankdirbug");
        }
        return this.rankDirBugEnabled;
    }

    public void setRailsEnabled(boolean enabled) {
        this.railsEnabled = enabled;
    }

    public boolean isRailsEnabled() {
        if (this.railsEnabled == null) {
            this.railsEnabled = this.options.remove("-rails");
        }
        return this.railsEnabled;
    }

    public void setNumRowsEnabled(boolean enabled) {
        this.numRowsEnabled = enabled;
    }

    public boolean isNumRowsEnabled() {
        if (this.numRowsEnabled == null) {
            this.numRowsEnabled = !this.options.remove("-norows");
        }
        return this.numRowsEnabled;
    }

    public void setViewsEnabled(boolean enabled) {
        this.viewsEnabled = enabled;
    }

    public boolean isViewsEnabled() {
        if (this.viewsEnabled == null) {
            this.viewsEnabled = !this.options.remove("-noviews");
        }
        return this.viewsEnabled;
    }

    public void setColumnExclusions(String columnExclusions) {
        this.columnExclusions = Pattern.compile(columnExclusions);
    }

    public Pattern getColumnExclusions() {
        if (this.columnExclusions == null) {
            String strExclusions = this.pullParam("-X");
            if (strExclusions == null) {
                strExclusions = System.getenv("schemaspy.columnExclusions");
            }
            if (strExclusions == null) {
                strExclusions = "[^.]";
            }
            this.columnExclusions = Pattern.compile(strExclusions);
        }
        return this.columnExclusions;
    }

    public void setIndirectColumnExclusions(String fullColumnExclusions) {
        this.indirectColumnExclusions = Pattern.compile(fullColumnExclusions);
    }

    public Pattern getIndirectColumnExclusions() {
        if (this.indirectColumnExclusions == null) {
            String strExclusions = this.pullParam("-x");
            if (strExclusions == null) {
                strExclusions = System.getenv("schemaspy.indirectColumnExclusions");
            }
            if (strExclusions == null) {
                strExclusions = "[^.]";
            }
            this.indirectColumnExclusions = Pattern.compile(strExclusions);
        }
        return this.indirectColumnExclusions;
    }

    public void setTableInclusions(String tableInclusions) {
        this.tableInclusions = Pattern.compile(tableInclusions);
    }

    public Pattern getTableInclusions() {
        if (this.tableInclusions == null) {
            String strInclusions = this.pullParam("-i");
            if (strInclusions == null) {
                strInclusions = System.getenv("schemaspy.tableInclusions");
            }
            if (strInclusions == null) {
                strInclusions = ".*";
            }
            try {
                this.tableInclusions = Pattern.compile(strInclusions);
            }
            catch (PatternSyntaxException badPattern) {
                throw new InvalidConfigurationException((Throwable)badPattern).setParamName("-i").setParamValue(strInclusions);
            }
        }
        return this.tableInclusions;
    }

    public void setTableExclusions(String tableExclusions) {
        this.tableExclusions = Pattern.compile(tableExclusions);
    }

    public Pattern getTableExclusions() {
        if (this.tableExclusions == null) {
            String strExclusions = this.pullParam("-I");
            if (strExclusions == null) {
                strExclusions = System.getenv("schemaspy.tableExclusions");
            }
            if (strExclusions == null) {
                strExclusions = ".*\\$.*";
            }
            try {
                this.tableExclusions = Pattern.compile(strExclusions);
            }
            catch (PatternSyntaxException badPattern) {
                throw new InvalidConfigurationException((Throwable)badPattern).setParamName("-I").setParamValue(strExclusions);
            }
        }
        return this.tableExclusions;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public List<String> getSchemas() {
        if (this.schemas == null) {
            String tmp = this.pullParam("-schemas");
            if (tmp == null) {
                tmp = this.pullParam("-schemata");
            }
            if (tmp != null) {
                this.schemas = new ArrayList();
                for (String name : tmp.split("[\\s,'\"]")) {
                    if (name.length() <= 0) continue;
                    this.schemas.add(name);
                }
                if (this.schemas.isEmpty()) {
                    this.schemas = null;
                }
            }
        }
        return this.schemas;
    }

    public void setEvaluateAllEnabled(boolean enabled) {
        this.evaluateAll = enabled;
    }

    public boolean isEvaluateAllEnabled() {
        if (this.evaluateAll == null) {
            this.evaluateAll = this.options.remove("-all");
        }
        return this.evaluateAll;
    }

    public boolean isOneOfMultipleSchemas() {
        return this.oneOfMultipleSchemas;
    }

    public void setOneOfMultipleSchemas(boolean oneOfMultipleSchemas) {
        this.oneOfMultipleSchemas = oneOfMultipleSchemas;
    }

    public void setSchemaSpec(String schemaSpec) {
        this.schemaSpec = schemaSpec;
    }

    public String getSchemaSpec() {
        if (this.schemaSpec == null) {
            this.schemaSpec = this.pullParam("-schemaSpec");
        }
        return this.schemaSpec;
    }

    public void setRenderer(String renderer) {
        this.renderer = renderer;
    }

    public String getRenderer() {
        if (this.renderer != null) {
            this.renderer = this.pullParam("-renderer");
        }
        return this.renderer;
    }

    public void setHighQuality(boolean highQuality) {
        this.highQuality = highQuality;
    }

    public boolean isHighQuality() {
        if (this.highQuality == null) {
            this.highQuality = this.options.remove("-hq");
        }
        return this.highQuality;
    }

    public boolean isLowQuality() {
        if (this.highQuality == null) {
            this.highQuality = !this.options.remove("-lq");
        }
        return this.highQuality == false;
    }

    public boolean isHelpRequired() {
        return this.helpRequired;
    }

    public boolean isDbHelpRequired() {
        return this.dbHelpRequired;
    }

    public static String getLoadedFromJar() {
        String loadedFrom = Config.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (loadedFrom.contains("!/BOOT-INF")) {
            try {
                loadedFrom = new URL(loadedFrom).getFile();
                loadedFrom = loadedFrom.substring(0, loadedFrom.indexOf(33));
            }
            catch (MalformedURLException e) {
                String classpath = System.getProperty("java.class.path");
                return new StringTokenizer(classpath, File.pathSeparator).nextToken();
            }
        }
        return loadedFrom;
    }

    public void setHasOrphans(boolean hasOrphans) {
        this.hasOrphans = hasOrphans;
    }

    public boolean hasOrphans() {
        return this.hasOrphans;
    }

    public void setHasRoutines(boolean hasRoutines) {
        this.hasRoutines = hasRoutines;
    }

    public boolean hasRoutines() {
        return this.hasRoutines;
    }

    public void setPaginationEnabled(boolean enabled) {
        this.paginationEnabled = enabled;
    }

    public boolean isPaginationEnabled() {
        if (this.paginationEnabled == null) {
            this.paginationEnabled = !this.options.remove("-nopages");
        }
        return this.paginationEnabled;
    }

    @Deprecated
    public void setLoadJDBCJarsEnabled(boolean enabled) {
        this.loadJDBCJarsEnabled = enabled;
    }

    @Deprecated
    public boolean isLoadJDBCJarsEnabled() {
        String loadJars = this.pullParam("-loadjars");
        if (loadJars != null && "true".equals(loadJars)) {
            this.loadJDBCJarsEnabled = true;
        }
        return this.loadJDBCJarsEnabled;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public String getImageFormat() {
        if (this.imageFormat == null) {
            this.imageFormat = this.pullParam("-imageformat");
            if (this.imageFormat == null) {
                this.imageFormat = "png";
            }
        }
        return this.imageFormat;
    }

    public Properties getDbProperties() {
        if (this.dbProperties == null) {
            this.dbProperties = this.propertiesResolver.getDbProperties(this.getDbType());
        }
        return this.dbProperties;
    }

    public Properties determineDbProperties(String type) {
        return this.propertiesResolver.getDbProperties(type);
    }

    public List<String> getRemainingParameters() {
        try {
            this.populate();
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException exc) {
            throw new InvalidConfigurationException((Throwable)exc);
        }
        catch (InvocationTargetException exc) {
            if (exc.getCause() instanceof InvalidConfigurationException) {
                throw (InvalidConfigurationException)exc.getCause();
            }
            throw new InvalidConfigurationException(exc.getCause());
        }
        return this.options;
    }

    public void setDbSpecificOptions(Map<String, String> dbSpecificOptions) {
        this.dbSpecificOptions = dbSpecificOptions;
        this.originalDbSpecificOptions = new HashMap<String, String>(dbSpecificOptions);
    }

    public Map<String, String> getDbSpecificOptions() {
        if (this.dbSpecificOptions == null) {
            this.dbSpecificOptions = new HashMap();
        }
        return this.dbSpecificOptions;
    }

    private String pullParam(String paramId) {
        return this.pullParam(paramId, false, false);
    }

    private String pullRequiredParam(String paramId) {
        return this.pullParam(paramId, true, false);
    }

    private String pullParam(String paramId, boolean required, boolean dbTypeSpecific) {
        int paramIndex = this.options.indexOf(paramId);
        if (paramIndex < 0) {
            if (required) {
                throw new MissingRequiredParameterException(paramId, dbTypeSpecific);
            }
            return null;
        }
        this.options.remove(paramIndex);
        String param = (String)this.options.get(paramIndex);
        this.options.remove(paramIndex);
        return param;
    }

    private List<String> fixupArgs(List<String> args) {
        ArrayList<String> expandedArgs = new ArrayList<String>();
        for (String string : args) {
            int indexOfEquals = string.indexOf(61);
            if (indexOfEquals != -1 && indexOfEquals - 1 != string.indexOf("\\=")) {
                expandedArgs.add(string.substring(0, indexOfEquals));
                expandedArgs.add(string.substring(indexOfEquals + 1));
                continue;
            }
            expandedArgs.add(string);
        }
        if (expandedArgs.indexOf("-configFile") < 0) {
            if (Config.fileExists((String)"schemaspy.properties")) {
                this.loadProperties("schemaspy.properties");
            }
        } else {
            this.loadProperties((String)expandedArgs.get(expandedArgs.indexOf("-configFile") + 1));
        }
        for (Map.Entry entry : this.schemaspyProperties.entrySet()) {
            if (expandedArgs.contains(entry.getKey().toString().replace("schemaspy.", "-"))) continue;
            expandedArgs.add(entry.getKey().toString().replace("schemaspy.", "-"));
            expandedArgs.add(entry.getValue().toString());
        }
        ArrayList<String> unquotedArgs = new ArrayList<String>();
        for (String arg : expandedArgs) {
            if (arg.startsWith("\"") && arg.endsWith("\"")) {
                arg = arg.substring(1, arg.length() - 1);
            }
            unquotedArgs.add(arg);
        }
        return unquotedArgs;
    }

    private void loadProperties(String path) {
        if (Config.fileExists((String)path)) {
            try (Stream<String> lineStream = Files.lines(Paths.get(path, new String[0]));){
                String content = lineStream.map(l -> l.replace("\\", "\\\\")).map(Config::rtrim).collect(Collectors.joining(System.lineSeparator()));
                this.schemaspyProperties.load(new StringReader(content));
                LOGGER.info("Loaded configuration from {}", (Object)path);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load configuration from '{}", (Object)path, (Object)e);
            }
        } else {
            LOGGER.warn("Configuration file '{}' not found", (Object)path);
        }
    }

    private static boolean fileExists(String path) {
        return Paths.get(path, new String[0]).toFile().exists();
    }

    private static String rtrim(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        return s.substring(0, i + 1);
    }

    private void populate() throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        if (!this.populating) {
            PropertyDescriptor[] props;
            this.populating = true;
            BeanInfo beanInfo = Introspector.getBeanInfo(Config.class);
            for (PropertyDescriptor prop : props = beanInfo.getPropertyDescriptors()) {
                Method readMethod = prop.getReadMethod();
                if (readMethod == null) continue;
                readMethod.invoke((Object)this, (Object[])null);
            }
            this.populating = false;
        }
    }

    public static Set<String> getBuiltInDatabaseTypes(String loadedFromJar) {
        TreeSet<String> databaseTypes = new TreeSet<String>();
        try (JarInputStream jar = new JarInputStream(new FileInputStream(loadedFromJar));){
            JarEntry entry;
            while ((entry = jar.getNextJarEntry()) != null) {
                Matcher dbTypeMatcher = DBTYPE_PATTERN.matcher(entry.getName());
                if (!dbTypeMatcher.find()) continue;
                databaseTypes.add(dbTypeMatcher.group(1));
            }
        }
        catch (IOException exc) {
            LOGGER.error("Failed to read bundled DatabaseTypes", (Throwable)exc);
        }
        return databaseTypes;
    }

    @Deprecated
    void dumpUsage(String errorMessage, boolean detailedDb) {
        if (errorMessage != null) {
            LOGGER.error("*** {} ***", (Object)errorMessage);
        } else {
            LOGGER.info("SchemaSpy generates an HTML representation of a database schema's relationships.");
        }
        if (!detailedDb) {
            LOGGER.info("Usage:");
            LOGGER.info(" java -jar {} [options]", (Object)Config.getLoadedFromJar());
            LOGGER.info("   -t databaseType       type of database - defaults to ora");
            LOGGER.info("                           use -dbhelp for a list of built-in types");
            LOGGER.info("   -u user               connect to the database with this user id");
            LOGGER.info("   -s schema             defaults to the specified user");
            LOGGER.info("   -p password           defaults to no password");
            LOGGER.info("   -o outputDirectory    directory to place the generated output in");
            LOGGER.info("   -dp pathToDrivers     optional - looks for JDBC drivers here before looking");
            LOGGER.info("                           in driverPath in [databaseType].properties.");
            LOGGER.info("Go to http://schemaspy.org for a complete list/description");
            LOGGER.info(" of additional parameters.");
        }
        if (detailedDb) {
            LOGGER.info("Missing required connection parameters for '{}'", (Object)this.getDbType());
            new DbSpecificConfig(this.getDbType(), this.getDbProperties()).dumpUsage();
        }
        if (detailedDb) {
            LOGGER.info("You can use your own database types by specifying the filespec of a .properties file with -t.");
            LOGGER.info("Grab one out of {} and modify it to suit your needs.", (Object)Config.getLoadedFromJar());
        }
        LOGGER.info("Sample usage using the default database type (implied -t ora):");
        LOGGER.info(" java -jar schemaSpy.jar -db mydb -s myschema -u devuser -p password -o output");
    }

    public String getParam(String paramName) {
        try {
            PropertyDescriptor[] props;
            BeanInfo beanInfo = Introspector.getBeanInfo(Config.class);
            for (PropertyDescriptor prop : props = beanInfo.getPropertyDescriptors()) {
                if (!prop.getName().equalsIgnoreCase(paramName)) continue;
                Object result = prop.getReadMethod().invoke((Object)this, (Object[])null);
                return result == null ? null : result.toString();
            }
        }
        catch (Exception failed) {
            LOGGER.error("Unable to get parameter {}", (Object)paramName, (Object)failed);
        }
        return null;
    }

    public List<String> asList() throws IOException {
        String value;
        ArrayList<String> params = new ArrayList<String>();
        if (this.originalDbSpecificOptions != null) {
            for (Map.Entry entry : this.originalDbSpecificOptions.entrySet()) {
                String key = (String)entry.getKey();
                String value2 = (String)entry.getValue();
                if (!key.startsWith("-")) {
                    key = "-" + key;
                }
                params.add(key);
                params.add(value2);
            }
        }
        if (this.isEvaluateAllEnabled()) {
            params.add("-all");
        }
        if (!this.isHtmlGenerationEnabled()) {
            params.add("-nohtml");
        }
        if (!this.isImpliedConstraintsEnabled()) {
            params.add("-noimplied");
        }
        if (!this.isNumRowsEnabled()) {
            params.add("-norows");
        }
        if (!this.isViewsEnabled()) {
            params.add("-noviews");
        }
        if (!this.isPaginationEnabled()) {
            params.add("-nopages");
        }
        if (!this.isLoadJDBCJarsEnabled()) {
            params.add("-loadjars");
        }
        if (this.isRankDirBugEnabled()) {
            params.add("-rankdirbug");
        }
        if (this.isRailsEnabled()) {
            params.add("-rails");
        }
        if (this.isSingleSignOn()) {
            params.add("-sso");
        }
        if ((value = this.getDriverPath()) != null) {
            params.add("-dp");
            params.add(value);
        }
        params.add("-css");
        params.add(this.getCss());
        params.add("-font");
        params.add(this.getFont());
        params.add("-fontsize");
        params.add(String.valueOf(this.getFontSize()));
        params.add("-t");
        params.add(this.getDbType());
        params.add("-imageformat");
        params.add(this.getImageFormat());
        this.isHighQuality();
        this.isLowQuality();
        params.add("-renderer");
        params.add(this.getRenderer());
        value = this.getDescription();
        if (value != null) {
            params.add("-desc");
            params.add(value);
        }
        if ((value = this.getPassword()) != null && !this.isPromptForPasswordEnabled()) {
            params.add("-p");
            params.add(value);
        }
        if ((value = this.getSchema()) != null) {
            params.add("-s");
            params.add(value);
        }
        if ((value = this.getUser()) != null) {
            params.add("-u");
            params.add(value);
        }
        if ((value = this.getConnectionPropertiesFile()) != null) {
            params.add("-connprops");
            params.add(value);
        } else {
            Properties props = this.getConnectionProperties();
            if (!props.isEmpty()) {
                params.add("-connprops");
                StringBuilder buf = new StringBuilder();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    buf.append(entry.getKey());
                    buf.append("\\=");
                    buf.append(entry.getValue());
                    buf.append(';');
                }
                params.add(buf.toString());
            }
        }
        value = this.getDb();
        if (value != null) {
            params.add("-db");
            params.add(value);
        }
        if ((value = this.getHost()) != null) {
            params.add("-host");
            params.add(value);
        }
        if (this.getPort() != null) {
            params.add("-port");
            params.add(this.getPort().toString());
        }
        if ((value = this.getMeta()) != null) {
            params.add("-meta");
            params.add(value);
        }
        if ((value = this.getTemplateDirectory()) != null) {
            params.add("-template");
            params.add(value);
        }
        if (this.getGraphvizDir() != null) {
            params.add("-gv");
            params.add(this.getGraphvizDir());
        }
        params.add("-i");
        params.add(this.getTableInclusions().toString());
        params.add("-I");
        params.add(this.getTableExclusions().toString());
        params.add("-X");
        params.add(this.getColumnExclusions().toString());
        params.add("-x");
        params.add(this.getIndirectColumnExclusions().toString());
        params.add("-dbthreads");
        params.add(String.valueOf(this.getMaxDbThreads()));
        params.add("-maxdet");
        params.add(String.valueOf(this.getMaxDetailedTables()));
        return params;
    }

    static {
        LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

