/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.TableColumn;
import org.schemaspy.view.MustacheTableColumnRelatives;

public class MustacheTableColumn {
    private TableColumn column;
    private List<MustacheTableColumnRelatives> parents = new ArrayList();
    private List<MustacheTableColumnRelatives> children = new ArrayList();
    private boolean indexColumn;

    public MustacheTableColumn(TableColumn tableColumn) {
        this.column = tableColumn;
        this.prepareRelatives(this.children, false);
        this.prepareRelatives(this.parents, true);
    }

    public MustacheTableColumn(TableColumn tableColumn, boolean indexColumn) {
        this(tableColumn);
        this.indexColumn = indexColumn;
    }

    public TableColumn getColumn() {
        return this.column;
    }

    public String getKey() {
        if (this.column.isPrimary()) {
            return " class='primaryKey' title='Primary Key'";
        }
        if (this.column.isForeignKey()) {
            return " class='foreignKey' title='Foreign Key'";
        }
        if (this.indexColumn) {
            return " class='" + this.markAsIndexColumn() + "' title='Indexed'";
        }
        return "";
    }

    public String getKeyTitle() {
        if (this.column.isPrimary()) {
            return "Primary Key";
        }
        if (this.column.isForeignKey()) {
            return "Foreign Key";
        }
        if (this.indexColumn) {
            return "Indexed";
        }
        return "";
    }

    public String getKeyClass() {
        if (this.column.isPrimary()) {
            return "primaryKey";
        }
        if (this.column.isForeignKey()) {
            return "foreignKey";
        }
        if (this.indexColumn) {
            return "indexedColumn";
        }
        return "";
    }

    public String getKeyIcon() {
        if (this.column.isPrimary() || this.column.isForeignKey()) {
            return "<i class='icon ion-key iconkey' style='padding-left: 5px;'></i>";
        }
        if (this.indexColumn) {
            return "<i class='fa fa-sitemap fa-rotate-120' style='padding-right: 5px;'></i>";
        }
        return "";
    }

    public String getNullable() {
        return this.column.isNullable() ? "\u221a" : "";
    }

    public String getTitleNullable() {
        return this.column.isNullable() ? "nullable" : "";
    }

    public String getAutoUpdated() {
        return this.column.isAutoUpdated() ? "\u221a" : "";
    }

    public String getTitleAutoUpdated() {
        return this.column.isAutoUpdated() ? "Automatically updated by the database" : "";
    }

    private String markAsIndexColumn() {
        return this.indexColumn ? "indexedColumn" : "";
    }

    public String getDefaultValue() {
        return String.valueOf(this.column.getDefaultValue());
    }

    public List<MustacheTableColumnRelatives> getParents() {
        return this.parents;
    }

    public List<MustacheTableColumnRelatives> getChildren() {
        return this.children;
    }

    public String getComments() {
        return this.column.getComments();
    }

    private void prepareRelatives(List<MustacheTableColumnRelatives> relatives, boolean dumpParents) {
        Set relativeColumns = dumpParents ? this.column.getParents() : this.column.getChildren();
        for (TableColumn relativeColumn : relativeColumns) {
            ForeignKeyConstraint constraint = dumpParents ? relativeColumn.getChildConstraint(this.column) : relativeColumn.getParentConstraint(this.column);
            MustacheTableColumnRelatives relative = new MustacheTableColumnRelatives(relativeColumn, constraint);
            relatives.add(relative);
        }
    }
}

