/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.MustacheResolver;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.schemaspy.util.DataTableConfig;
import org.schemaspy.util.naming.Name;
import org.schemaspy.util.naming.NameFromString;
import org.schemaspy.util.naming.SanitizedFileName;
import org.schemaspy.view.HtmlConfig;
import org.schemaspy.view.MustacheCustomResolver;
import org.schemaspy.view.PageData;

public class MustacheCompiler {
    private final String databaseName;
    private final String schemaName;
    private final HtmlConfig htmlConfig;
    private final boolean multiSchema;
    private final DataTableConfig dataTableConfig;
    private final MustacheFactory mustacheFactory;

    public MustacheCompiler(String databaseName, String schemaName, HtmlConfig htmlConfig, boolean multiSchema, DataTableConfig dataTableConfig) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.htmlConfig = htmlConfig;
        this.multiSchema = multiSchema;
        this.dataTableConfig = dataTableConfig;
        this.mustacheFactory = new DefaultMustacheFactory((MustacheResolver)new MustacheCustomResolver(htmlConfig.getTemplateDirectory()));
    }

    public void write(PageData pageData, Writer writer) throws IOException {
        StringWriter result = new StringWriter();
        HashMap<String, Object> pageScope = new HashMap<String, Object>();
        pageScope.put("toFileName", s -> new SanitizedFileName((Name)new NameFromString(s)).value());
        pageScope.put("databaseName", this.databaseName);
        pageScope.put("schemaName", this.schemaName);
        pageScope.put("paginationEnabled", this.htmlConfig.isPaginationEnabled());
        pageScope.put("displayNumRows", this.htmlConfig.isNumRowsEnabled());
        pageScope.put("dataTableConfig", this.dataTableConfig.getPageScopeMap());
        pageScope.put("markup", md -> this.htmlConfig.markupProcessor(md, this.getRootPath(pageData.getDepth())).value());
        pageScope.putAll(pageData.getScope());
        Mustache mustachePage = this.mustacheFactory.compile(pageData.getTemplateName());
        mustachePage.execute((Writer)result, pageScope).flush();
        HashMap<String, Object> containerScope = new HashMap<String, Object>();
        containerScope.put("content", result);
        containerScope.put("pageScript", pageData.getScriptName());
        containerScope.put("rootPath", this.getRootPath(pageData.getDepth()));
        containerScope.put("rootPathToHome", this.getRootPathToHome(pageData.getDepth()));
        containerScope.putAll(pageScope);
        Mustache mustacheContainer = this.mustacheFactory.compile("container.html");
        mustacheContainer.execute(writer, containerScope).flush();
    }

    public String getRootPath(int depth) {
        return IntStream.range(0, depth).mapToObj(i -> "../").collect(Collectors.joining("", "", ""));
    }

    private String getRootPathToHome(int depth) {
        Object path = this.getRootPath(depth);
        if (this.multiSchema) {
            path = (String)path + "../";
        }
        return path;
    }
}

