/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.schemaspy.DbAnalyzer;
import org.schemaspy.model.Database;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.Table;
import org.schemaspy.view.MustacheCompiler;
import org.schemaspy.view.MustacheTable;
import org.schemaspy.view.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HtmlMainIndexPage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MustacheCompiler mustacheCompiler;
    private final String description;

    public HtmlMainIndexPage(MustacheCompiler mustacheCompiler, String description) {
        this.mustacheCompiler = mustacheCompiler;
        this.description = description;
    }

    public void write(Database database, Collection<Table> tables, List<? extends ForeignKeyConstraint> impliedConstraints, Writer writer) {
        ArrayList<MustacheTable> mustacheTables = new ArrayList<MustacheTable>();
        long columnsAmount = 0L;
        for (Table table : tables) {
            columnsAmount += (long)table.getColumns().size();
            String comments = table.getComments();
            MustacheTable mustacheTable = new MustacheTable(table, "");
            mustacheTable.setComments(comments);
            mustacheTables.add(mustacheTable);
        }
        long tablesAmount = tables.stream().filter(t -> !t.isView()).count();
        long viewsAmount = tables.stream().filter(Table::isView).count();
        long constraintsAmount = DbAnalyzer.getForeignKeyConstraints(tables).size();
        long routinesAmount = database.getRoutines().size();
        long anomaliesAmount = HtmlMainIndexPage.getAllAnomaliesAmount(tables, impliedConstraints);
        PageData pageData = new PageData.Builder().templateName("main.html").scriptName("main.js").addToScope("tablesAmount", (Object)tablesAmount).addToScope("viewsAmount", (Object)viewsAmount).addToScope("columnsAmount", (Object)columnsAmount).addToScope("constraintsAmount", (Object)constraintsAmount).addToScope("routinesAmount", (Object)routinesAmount).addToScope("anomaliesAmount", (Object)anomaliesAmount).addToScope("tables", mustacheTables).addToScope("database", (Object)database).addToScope("description", (Object)this.description).addToScope("schema", (Object)database.getSchema()).addToScope("catalog", (Object)database.getCatalog()).addToScope("xmlName", (Object)HtmlMainIndexPage.getXmlName((Database)database)).depth(0).getPageData();
        try {
            this.mustacheCompiler.write(pageData, writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write main index page", (Throwable)e);
        }
    }

    private static long getAllAnomaliesAmount(Collection<Table> tables, List<? extends ForeignKeyConstraint> impliedConstraints) {
        long anomalies = 0L;
        anomalies += (long)DbAnalyzer.getTablesWithoutIndexes(new HashSet<Table>(tables)).size();
        anomalies += impliedConstraints.stream().filter(c -> !c.getChildTable().isView()).count();
        anomalies += DbAnalyzer.getTablesWithOneColumn(tables).stream().filter(t -> !t.isView()).count();
        anomalies += DbAnalyzer.getTablesWithIncrementingColumnNames(tables).stream().filter(t -> !t.isView()).count();
        return anomalies += (long)DbAnalyzer.getDefaultNullStringColumns(new HashSet<Table>(tables)).size();
    }

    private static String getXmlName(Database db) {
        if (db.getSchema() != null) {
            return db.getName() + "." + db.getSchema().getName();
        }
        if (db.getCatalog() != null) {
            return db.getName() + "." + db.getCatalog().getName();
        }
        return db.getName();
    }
}

