/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Collection;
import org.schemaspy.cli.NoRowsConfigCli;
import org.schemaspy.cli.TemplateDirectoryConfigCli;
import org.schemaspy.model.Table;
import org.schemaspy.util.markup.Asciidoc;
import org.schemaspy.util.markup.Markdown;
import org.schemaspy.util.markup.Markup;
import org.schemaspy.util.markup.MarkupFromString;
import org.schemaspy.util.markup.PageRegistry;
import org.schemaspy.util.markup.WithReferenceLinks;
import org.schemaspy.view.HtmlConfig;

@Parameters(resourceBundle="htmlconfigcli")
public class HtmlConfigCli
implements HtmlConfig {
    @Parameter(names={"-desc", "--description", "schemaspy.desc", "schemaspy.description"}, descriptionKey="desc")
    private String description;
    @Parameter(names={"-nopages", "--no-pages", "schemaspy.nopages", "schemaspy.no-pages"}, descriptionKey="nopages")
    private boolean noPages = false;
    @Parameter(names={"-asciidoc", "--asciidoc", "schemaspy.asciidoc"}, descriptionKey="asciidoc")
    private boolean useAsciiDoc = false;
    private final NoRowsConfigCli noRowsConfigCli;
    private final TemplateDirectoryConfigCli templateDirectoryConfigCli;
    private final PageRegistry pageRegistry = new PageRegistry();

    public HtmlConfigCli(NoRowsConfigCli noRowsConfigCli, TemplateDirectoryConfigCli templateDirectoryConfigCli) {
        this.noRowsConfigCli = noRowsConfigCli;
        this.templateDirectoryConfigCli = templateDirectoryConfigCli;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTemplateDirectory() {
        return this.templateDirectoryConfigCli.getTemplateDirectory();
    }

    public boolean isPaginationEnabled() {
        return !this.noPages;
    }

    public boolean isNumRowsEnabled() {
        return this.noRowsConfigCli.isNumRowsEnabled();
    }

    public void registryPage(Collection<Table> tables) {
        this.pageRegistry.register(tables);
    }

    public Markup markupProcessor(String markupText, String rootPath) {
        if (this.useAsciiDoc) {
            return new Asciidoc((Markup)new WithReferenceLinks((Markup)new MarkupFromString(markupText), this.pageRegistry, rootPath, "link:%2$s[%1$s]"));
        }
        return new Markdown((Markup)new WithReferenceLinks((Markup)new MarkupFromString(markupText), this.pageRegistry, rootPath, "[%1$s](%2$s)"));
    }
}

