/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.util.naming;

import org.schemaspy.util.naming.Name;

public class SanitizedFileName
implements Name {
    private final Name origin;

    public SanitizedFileName(Name name) {
        this.origin = name;
    }

    public String value() {
        String originValue = this.origin.value();
        String name = originValue.replaceAll("[^a-zA-Z0-9\\-_.]", "_");
        if (name.length() <= 40 && originValue.equalsIgnoreCase(name)) {
            return name;
        }
        String hashAsHex = Integer.toHexString(originValue.hashCode());
        int targetLength = Math.min(39 - hashAsHex.length(), name.length());
        return name.substring(0, targetLength) + "_" + hashAsHex;
    }
}

