/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.util.markup;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.schemaspy.util.markup.Markup;
import org.schemaspy.util.markup.PageRegistry;

public class WithReferenceLinks
implements Markup {
    private final PageRegistry pageRegistry;
    private final Markup origin;
    private final String rootPath;
    private final String linkFormat;

    public WithReferenceLinks(Markup origin, PageRegistry pageRegistry, String rootPath, String linkFormat) {
        this.origin = origin;
        this.pageRegistry = pageRegistry;
        this.rootPath = rootPath;
        this.linkFormat = linkFormat;
    }

    public String value() {
        String originValue;
        String markupTextWithReferenceLink = originValue = this.origin.value();
        String basePath = this.rootPath == null || this.rootPath.isEmpty() ? "." : this.rootPath;
        Pattern p = Pattern.compile("\\[(.*?)]");
        Matcher m = p.matcher(originValue);
        while (m.find()) {
            Object pagePath;
            String pageLink;
            String tableName = pageLink = m.group(1);
            String anchorLink = "";
            int anchorPosition = pageLink.lastIndexOf(46);
            if (anchorPosition > -1) {
                anchorLink = pageLink.substring(anchorPosition + 1).trim();
                tableName = pageLink.substring(0, anchorPosition);
            }
            if ((pagePath = this.pageRegistry.pathForPage(tableName)) == null) continue;
            pagePath = String.format("%s/%s", basePath, pagePath);
            if (!anchorLink.isEmpty()) {
                pagePath = (String)pagePath + "#" + anchorLink;
            }
            markupTextWithReferenceLink = markupTextWithReferenceLink.replace(String.format("[%s]", pageLink), this.linkFormat.formatted(pageLink, pagePath));
        }
        return markupTextWithReferenceLink;
    }
}

