/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.util.iterator;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class Filtered<T>
implements Iterator<T> {
    private final Iterator<T> origin;
    private final Predicate<T> predicate;
    private final LinkedList<T> buffer;

    public Filtered(Iterator<T> origin, Predicate<T> predicate) {
        this.origin = origin;
        this.predicate = predicate;
        this.buffer = new LinkedList();
    }

    @Override
    public boolean hasNext() {
        while (this.buffer.isEmpty() && this.origin.hasNext()) {
            Object nextElement = this.origin.next();
            if (!this.predicate.test(nextElement)) continue;
            this.buffer.add(nextElement);
        }
        return !this.buffer.isEmpty();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return (T)this.buffer.removeFirst();
        }
        throw new NoSuchElementException();
    }
}

