/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.util;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.schemaspy.util.DbSpecificOption;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class DbSpecificConfig {
    private static final Pattern OPTION_PATTER = Pattern.compile("<([a-zA-Z0-9.\\-_]+)>");
    private static final String DUMP_FORMAT = "      -%s   \t\t%s";
    private final String dbType;
    private final Properties properties;

    public DbSpecificConfig(String dbType, Properties props) {
        this.dbType = dbType;
        this.properties = props;
    }

    public List<DbSpecificOption> getOptions() {
        Set optionsFound = DbSpecificConfig.findOptions((String)this.properties.getProperty("connectionSpec"));
        return optionsFound.stream().map(optionName -> new DbSpecificOption(optionName, this.properties.getProperty((String)optionName))).collect(Collectors.toList());
    }

    private static Set<String> findOptions(String connectionSpec) {
        LinkedHashSet<String> optionsFound = new LinkedHashSet<String>();
        Matcher matcher = OPTION_PATTER.matcher(connectionSpec);
        while (matcher.find()) {
            optionsFound.add(matcher.group(1));
        }
        return optionsFound;
    }

    public void dumpUsage(Logger logger) {
        logger.info("   {} (-t {})", (Object)this, (Object)this.dbType);
        this.getOptions().stream().flatMap(option -> {
            if ("hostOptionalPort".equals(option.getName())) {
                return Stream.of(String.format("      -%s   \t\t%s", "host", "host of database, may contain port"), String.format("      -%s   \t\t%s", "port", "optional port if not default"));
            }
            return Stream.of(String.format("      -%s   \t\t%s", option.getName(), DbSpecificConfig.getDescription((DbSpecificOption)option)));
        }).forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private static String getDescription(DbSpecificOption option) {
        return Objects.isNull(option.getDescription()) ? "" : option.getDescription();
    }

    public String toString() {
        return this.properties.getProperty("description");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DbSpecificConfig) {
            DbSpecificConfig that = (DbSpecificConfig)o;
            return this.dbType.equals(that.dbType) && this.properties.equals(that.properties);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dbType, this.properties);
    }
}

