/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.progress;

import java.time.Duration;
import java.time.Instant;
import java.time.InstantSource;
import org.schemaspy.progress.Condition;

public class IfUpdateAfter
implements Condition {
    private final InstantSource instantSource;
    private final Duration updateFrequency;
    private Instant nextUpdate;

    public IfUpdateAfter(Duration updateFrequency, InstantSource instantSource) {
        this.updateFrequency = updateFrequency;
        this.instantSource = instantSource;
        this.nextUpdate = this.instantSource.instant().plus(this.updateFrequency);
    }

    public boolean report() {
        Instant now = this.instantSource.instant();
        if (now.isAfter(this.nextUpdate)) {
            this.nextUpdate = now.plus(this.updateFrequency);
            return true;
        }
        return false;
    }
}

