/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.progress;

import java.time.Duration;
import java.time.Instant;
import java.time.InstantSource;
import java.util.concurrent.atomic.LongAdder;
import org.schemaspy.progress.Condition;
import org.schemaspy.progress.FinishCallback;
import org.schemaspy.progress.Job;
import org.schemaspy.progress.Proc;
import org.schemaspy.progress.ProgressReporter;

public class ConditionalProgress<T extends Throwable>
implements Proc<T> {
    private final ProgressReporter progressReporter;
    private final FinishCallback finishCallback;
    private final Condition condition;
    private final Job<T> job;
    private final InstantSource instantSource;

    public ConditionalProgress(ProgressReporter progressReporter, FinishCallback finishCallback, Condition condition, Job<T> job, InstantSource instantSource) {
        this.progressReporter = progressReporter;
        this.finishCallback = finishCallback;
        this.condition = condition;
        this.job = job;
        this.instantSource = instantSource;
    }

    public void execute() throws T {
        LongAdder increments = new LongAdder();
        Instant start = this.instantSource.instant();
        this.job.execute(() -> {
            increments.increment();
            if (this.condition.report()) {
                this.progressReporter.report(increments.sum());
            }
        });
        this.finishCallback.finished(increments.sum(), Duration.between(start, this.instantSource.instant()));
    }
}

