/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.xml.dom;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.schemaspy.model.Database;
import org.schemaspy.output.xml.XmlProducer;
import org.schemaspy.output.xml.XmlProducerException;
import org.schemaspy.output.xml.dom.DOMUtil;
import org.schemaspy.output.xml.dom.XmlRoutineFormatter;
import org.schemaspy.output.xml.dom.XmlSequenceFormatter;
import org.schemaspy.output.xml.dom.XmlTableFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlProducerUsingDOM
implements XmlProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final XmlTableFormatter xmlTableFormatter = new XmlTableFormatter();
    private final XmlRoutineFormatter xmlRoutineFormatter = new XmlRoutineFormatter();
    private final XmlSequenceFormatter xmlSequenceFormatter = new XmlSequenceFormatter();

    public void generate(Database database, File outputDir) {
        DocumentBuilder builder;
        ArrayList tables = new ArrayList(database.getTables());
        tables.addAll(database.getViews());
        if (tables.isEmpty()) {
            LOGGER.info("No tables to output, nothing written to disk");
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn("Failed to set secure processing for DocumentBuilderFactory", (Throwable)e);
        }
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exc) {
            throw new XmlProducerException("Failed to get a newDocumentBuilder()", (Throwable)exc);
        }
        Document document = builder.newDocument();
        Element rootNode = document.createElement("database");
        document.appendChild(rootNode);
        DOMUtil.appendAttribute((Node)rootNode, (String)"name", (String)database.getName());
        if (Objects.nonNull(database.getSchema())) {
            DOMUtil.appendAttribute((Node)rootNode, (String)"schema", (String)database.getSchema().getName());
        }
        DOMUtil.appendAttribute((Node)rootNode, (String)"type", (String)database.getDatabaseProduct());
        this.xmlSequenceFormatter.appendSequences(rootNode, database.getSequences());
        this.xmlTableFormatter.appendTables(rootNode, tables);
        this.xmlRoutineFormatter.appendRoutines(rootNode, database.getRoutines());
        Object xmlName = database.getName();
        xmlName = new File((String)xmlName).getName();
        String[] unusables = ((String)xmlName).split("[:@]");
        xmlName = unusables[unusables.length - 1];
        if (Objects.nonNull(database.getSchema())) {
            xmlName = (String)xmlName + "." + database.getSchema().getName();
        }
        document.getDocumentElement().normalize();
        Path xmlFile = outputDir.toPath().resolve((String)xmlName + ".xml");
        try (BufferedWriter writer = Files.newBufferedWriter(xmlFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            XmlProducerUsingDOM.write((Document)document, (Writer)writer);
        }
        catch (IOException e) {
            throw new XmlProducerException("Unable to write xml to disk", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new XmlProducerException("Unable to transform dom document to xml", (Throwable)e);
        }
    }

    private static void write(Document document, Writer writer) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        transformer.transform(new DOMSource(document), new StreamResult(writer));
    }
}

