/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy.edge;

import java.util.HashSet;
import java.util.Set;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.output.dot.schemaspy.Edge;
import org.schemaspy.output.dot.schemaspy.edge.Edges;

public class RelatedEdges
implements Edges {
    private final TableColumn column;
    private final Table targetTable;
    private final boolean includeExcluded;
    private final boolean includeImplied;

    public RelatedEdges(TableColumn column, Table targetTable, boolean includeExcluded, boolean includeImplied) {
        this.column = column;
        this.targetTable = targetTable;
        this.includeExcluded = includeExcluded;
        this.includeImplied = includeImplied;
    }

    public Set<Edge> unique() {
        HashSet<Edge> relatedConnectors = new HashSet<Edge>();
        if (!this.includeExcluded && this.column.isExcluded()) {
            return relatedConnectors;
        }
        relatedConnectors.addAll(this.relatedParents());
        relatedConnectors.addAll(this.relatedChildren());
        return relatedConnectors;
    }

    private Set<Edge> relatedParents() {
        HashSet<Edge> relatedConnectors = new HashSet<Edge>();
        for (TableColumn parentColumn : this.column.getParents()) {
            boolean implied;
            Table parentTable = parentColumn.getTable();
            if (this.isNotTarget(parentTable) || this.shouldExclude(parentColumn) || (implied = this.column.getParentConstraint(parentColumn).isImplied()) && !this.includeImplied) continue;
            relatedConnectors.add(new Edge(parentColumn, this.column, implied));
        }
        return relatedConnectors;
    }

    private boolean isNotTarget(Table candidate) {
        return this.targetTable != null && candidate != this.targetTable;
    }

    private boolean shouldExclude(TableColumn candidate) {
        return this.targetTable == null && !this.includeExcluded && candidate.isExcluded();
    }

    private Set<Edge> relatedChildren() {
        HashSet<Edge> relatedConnectors = new HashSet<Edge>();
        for (TableColumn childColumn : this.column.getChildren()) {
            boolean implied;
            Table childTable = childColumn.getTable();
            if (this.isNotTarget(childTable) || this.shouldExclude(childColumn) || (implied = this.column.getChildConstraint(childColumn).isImplied()) && !this.includeImplied) continue;
            relatedConnectors.add(new Edge(this.column, childColumn, implied));
        }
        return relatedConnectors;
    }
}

