/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.output.dot.RuntimeDotConfig;
import org.schemaspy.output.dot.schemaspy.DotConfigHeader;
import org.schemaspy.output.dot.schemaspy.DotNode;
import org.schemaspy.output.dot.schemaspy.DotNodeConfig;
import org.schemaspy.output.dot.schemaspy.Edge;
import org.schemaspy.output.dot.schemaspy.Header;
import org.schemaspy.output.dot.schemaspy.columnsfilter.Columns;
import org.schemaspy.output.dot.schemaspy.columnsfilter.factory.Default;
import org.schemaspy.output.dot.schemaspy.columnsfilter.factory.Factory;
import org.schemaspy.output.dot.schemaspy.columnsfilter.factory.Included;
import org.schemaspy.output.dot.schemaspy.edge.PairEdges;
import org.schemaspy.output.dot.schemaspy.edge.SimpleEdges;
import org.schemaspy.output.dot.schemaspy.graph.Digraph;
import org.schemaspy.output.dot.schemaspy.graph.Element;
import org.schemaspy.output.dot.schemaspy.name.DefaultName;
import org.schemaspy.output.dot.schemaspy.name.Degree;
import org.schemaspy.output.dot.schemaspy.name.Implied;
import org.schemaspy.output.dot.schemaspy.relationship.Relationships;
import org.schemaspy.util.naming.Concatenation;
import org.schemaspy.util.naming.Name;

/*
 * Exception performing whole class analysis ignored.
 */
public class DotTableFormatter
implements Relationships {
    private final RuntimeDotConfig runtimeDotConfig;
    private final Table table;
    private final boolean twoDegreesOfSeparation;
    private final LongAdder stats;
    private final boolean includeImplied;
    private final PrintWriter dot;
    private final Header header;
    private final Name graph;

    public DotTableFormatter(RuntimeDotConfig runtimeDotConfig, Table table, boolean twoDegreesOfSeparation, LongAdder stats, boolean includeImplied, PrintWriter dot) {
        this(runtimeDotConfig, table, twoDegreesOfSeparation, stats, includeImplied, dot, (Header)new DotConfigHeader(runtimeDotConfig, true), (Name)new Concatenation((Name)new Degree(twoDegreesOfSeparation), (Name)new Concatenation((Name)new DefaultName(), (Name)new Implied(includeImplied))));
    }

    public DotTableFormatter(RuntimeDotConfig runtimeDotConfig, Table table, boolean twoDegreesOfSeparation, LongAdder stats, boolean includeImplied, PrintWriter dot, Header header, Name graph) {
        this.runtimeDotConfig = runtimeDotConfig;
        this.table = table;
        this.twoDegreesOfSeparation = twoDegreesOfSeparation;
        this.stats = stats;
        this.includeImplied = includeImplied;
        this.dot = dot;
        this.header = header;
        this.graph = graph;
    }

    public void write() {
        this.writeTableRelationships();
    }

    private void writeTableRelationships() {
        HashSet<Table> tablesWritten = new HashSet<Table>();
        Factory factory = DotTableFormatter.getFactory((Table)this.table, (boolean)true);
        Set relatedTables = DotTableFormatter.immediateRelatives((Table)this.table, (Factory)factory, (boolean)this.includeImplied);
        TreeSet<Object> edges = new TreeSet<Object>(new SimpleEdges(this.table, this.includeImplied).unique());
        tablesWritten.add(this.table);
        TreeMap<Table, DotNode> nodes = new TreeMap<Table, DotNode>();
        List unwritten = relatedTables.stream().filter(relative -> !tablesWritten.contains(relative)).collect(Collectors.toList());
        nodes.putAll(this.immediateRelativesNodes(unwritten));
        edges.addAll(this.immediateRelativesEdges(unwritten));
        this.connectEdges(edges);
        HashSet allCousins = new HashSet();
        TreeSet<Edge> allCousinEdges = new TreeSet<Edge>();
        if (this.twoDegreesOfSeparation) {
            this.writeCousins(relatedTables, tablesWritten, allCousinEdges, nodes, allCousins);
        }
        ArrayList participants = new ArrayList(nodes.keySet());
        Iterator iter = participants.iterator();
        while (iter.hasNext()) {
            Table participantA = (Table)iter.next();
            iter.remove();
            for (Table participantB : participants) {
                for (Edge edge : new PairEdges(participantA, participantB, false, this.includeImplied).unique()) {
                    if (this.isCousinEdge(allCousins, participantA, participantB)) {
                        allCousinEdges.add(edge);
                        continue;
                    }
                    edges.add(edge);
                }
            }
        }
        this.connectLooseEnds(allCousinEdges, allCousins, relatedTables);
        nodes.put(this.table, new DotNode(this.table, false, new DotNodeConfig(true, true), this.runtimeDotConfig));
        edges.addAll(allCousinEdges);
        this.implyParents(edges, nodes);
        this.implyChildren(edges, nodes);
        LinkedList<Object> elements = new LinkedList<Object>();
        elements.addAll(edges);
        elements.addAll(nodes.values());
        this.stats.add(nodes.size());
        this.dot.println(new Digraph(this.graph, this.header, (Element[])elements.stream().toArray(Element[]::new)).dot());
    }

    private static Factory getFactory(Table table, boolean includeExcluded) {
        Default factory = new Default(table);
        if (includeExcluded) {
            factory = new Included((Factory)factory);
        }
        return factory;
    }

    private static Set<Table> immediateRelatives(Table table, Factory factory, boolean includeImplied) {
        HashSet<Table> relatedTables = new HashSet<Table>();
        relatedTables.addAll(DotTableFormatter.childrenTables((Factory)factory, (boolean)includeImplied));
        relatedTables.addAll(DotTableFormatter.parentsTables((Factory)factory, (boolean)includeImplied));
        relatedTables.remove(table);
        return relatedTables;
    }

    private static Set<Table> childrenTables(Factory factory, boolean includeImplied) {
        Columns columns = factory.columns();
        HashSet<Table> result = new HashSet<Table>();
        for (TableColumn column : columns.value()) {
            Columns children = factory.children(column);
            for (TableColumn childColumn : children.value()) {
                ForeignKeyConstraint constraint = column.getChildConstraint(childColumn);
                if (!includeImplied && constraint.isImplied()) continue;
                result.add(childColumn.getTable());
            }
        }
        return result;
    }

    private static Set<Table> parentsTables(Factory factory, boolean includeImplied) {
        Columns columns = factory.columns();
        HashSet<Table> result = new HashSet<Table>();
        for (TableColumn column : columns.value()) {
            Columns parents = factory.parents(column);
            for (TableColumn parentColumn : parents.value()) {
                ForeignKeyConstraint constraint = column.getParentConstraint(parentColumn);
                if (!includeImplied && constraint.isImplied()) continue;
                result.add(parentColumn.getTable());
            }
        }
        return result;
    }

    private Map<Table, DotNode> immediateRelativesNodes(List<Table> tables) {
        HashMap<Table, DotNode> result = new HashMap<Table, DotNode>();
        for (Table relatedTable : tables) {
            DotNodeConfig nodeConfigurations = new DotNodeConfig(false, false);
            DotNode node = new DotNode(relatedTable, false, nodeConfigurations, this.runtimeDotConfig);
            result.put(relatedTable, node);
        }
        return result;
    }

    private Set<Edge> immediateRelativesEdges(List<Table> tables) {
        HashSet<Edge> result = new HashSet<Edge>();
        for (Table relatedTable : tables) {
            result.addAll(new PairEdges(relatedTable, this.table, true, this.includeImplied).unique());
        }
        return result;
    }

    private void connectEdges(Set<Edge> edges) {
        for (Edge edge : edges) {
            edge.connectToDetailsLogically(this.table);
        }
    }

    private void writeCousins(Set<Table> relatedTables, Set<Table> tablesWritten, Set<Edge> allCousinEdges, Map<Table, DotNode> nodes, Set<Table> allCousins) {
        for (Table relatedTable : relatedTables) {
            Set cousins = this.cousinsOf(relatedTable);
            List missing = cousins.stream().filter(cousin -> !tablesWritten.contains(cousin)).collect(Collectors.toList());
            for (Table cousin2 : missing) {
                Set edges = new PairEdges(cousin2, relatedTable, false, this.includeImplied).unique();
                allCousinEdges.addAll(edges);
            }
            for (Table cousin2 : missing) {
                DotNode node = new DotNode(cousin2, false, new DotNodeConfig(), this.runtimeDotConfig);
                nodes.put(cousin2, node);
            }
            tablesWritten.addAll(missing);
            allCousins.addAll(cousins);
        }
    }

    private Set<Table> cousinsOf(Table relatedTable) {
        Factory cousinsFactory = DotTableFormatter.getFactory((Table)relatedTable, (boolean)false);
        return DotTableFormatter.immediateRelatives((Table)relatedTable, (Factory)cousinsFactory, (boolean)this.includeImplied);
    }

    private boolean isCousinEdge(Set<Table> allCousins, Table participantA, Table participantB) {
        return this.twoDegreesOfSeparation && (allCousins.contains(participantA) || allCousins.contains(participantB));
    }

    private void connectLooseEnds(Set<Edge> allCousinEdges, Set<Table> allCousins, Set<Table> relatedTables) {
        for (Edge edge : allCousinEdges) {
            if (this.isCousinTable(edge.getParentTable(), allCousins, relatedTables)) {
                edge.connectToParentTitle();
            }
            if (!this.isCousinTable(edge.getChildTable(), allCousins, relatedTables)) continue;
            edge.connectToChildTitle();
        }
    }

    private boolean isCousinTable(Table candidate, Set<Table> allCousins, Set<Table> relatedTables) {
        return allCousins.contains(candidate) && !relatedTables.contains(candidate);
    }

    private void implyParents(Set<Edge> edges, Map<Table, DotNode> nodes) {
        for (Edge edge : edges) {
            DotNode node;
            if (!edge.isImplied() || (node = nodes.get(edge.getParentTable())) == null) continue;
            node.setShowImplied(true);
        }
    }

    private void implyChildren(Set<Edge> edges, Map<Table, DotNode> nodes) {
        for (Edge edge : edges) {
            DotNode node;
            if (!edge.isImplied() || (node = nodes.get(edge.getChildTable())) == null) continue;
            node.setShowImplied(true);
        }
    }
}

