/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeSet;
import org.schemaspy.model.Database;
import org.schemaspy.model.Table;
import org.schemaspy.output.dot.RuntimeDotConfig;
import org.schemaspy.output.dot.schemaspy.DotConfigHeader;
import org.schemaspy.output.dot.schemaspy.DotNode;
import org.schemaspy.output.dot.schemaspy.DotNodeConfig;
import org.schemaspy.output.dot.schemaspy.Header;
import org.schemaspy.output.dot.schemaspy.edge.SimpleEdges;
import org.schemaspy.output.dot.schemaspy.graph.Digraph;
import org.schemaspy.output.dot.schemaspy.graph.Element;
import org.schemaspy.output.dot.schemaspy.name.DefaultName;
import org.schemaspy.output.dot.schemaspy.name.Implied;
import org.schemaspy.output.dot.schemaspy.name.Sized;
import org.schemaspy.util.naming.Concatenation;
import org.schemaspy.util.naming.Name;

public class DotSummaryFormatter {
    private final RuntimeDotConfig runtimeDotConfig;
    private final boolean includeOrphans;

    public DotSummaryFormatter(RuntimeDotConfig runtimeDotConfig, boolean includeOrphans) {
        this.runtimeDotConfig = runtimeDotConfig;
        this.includeOrphans = includeOrphans;
    }

    public void writeSummaryRealRelationships(Database db, Collection<Table> tables, boolean compact, PrintWriter dot) {
        this.writeRelationships(db, tables, compact, false, dot);
    }

    public void writeSummaryAllRelationships(Database db, Collection<Table> tables, boolean compact, PrintWriter dot) {
        this.writeRelationships(db, tables, compact, true, dot);
    }

    private void writeRelationships(Database db, Collection<Table> tables, boolean compact, boolean includeImplied, PrintWriter dot) {
        DotNodeConfig nodeConfig = this.runtimeDotConfig.showDetails(tables) ? new DotNodeConfig(!compact, false) : new DotNodeConfig();
        Concatenation name = new Concatenation((Name)new Sized(compact), (Name)new Concatenation((Name)new Implied(includeImplied), (Name)new DefaultName()));
        LinkedList<DotNode> nodes = new LinkedList<DotNode>();
        for (Table table : tables) {
            if (this.includeOrphans) {
                nodes.add(new DotNode(table, true, nodeConfig, this.runtimeDotConfig));
                continue;
            }
            if (table.isOrphan(includeImplied)) continue;
            nodes.add(new DotNode(table, true, nodeConfig, this.runtimeDotConfig));
        }
        for (Table table : db.getRemoteTables()) {
            nodes.add(new DotNode(table, true, nodeConfig, this.runtimeDotConfig));
        }
        TreeSet edges = new TreeSet();
        for (DotNode node : nodes) {
            edges.addAll(new SimpleEdges(node.getTable(), includeImplied).unique());
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.addAll(nodes);
        linkedList.addAll(edges);
        dot.println(new Digraph((Name)name, (Header)new DotConfigHeader(this.runtimeDotConfig, true), (Element[])linkedList.stream().toArray(Element[]::new)).dot());
        dot.flush();
    }
}

