/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy;

import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.model.TableIndex;
import org.schemaspy.output.dot.RuntimeDotConfig;
import org.schemaspy.output.dot.schemaspy.DotNodeConfig;
import org.schemaspy.output.dot.schemaspy.Html;
import org.schemaspy.output.dot.schemaspy.Node;
import org.schemaspy.output.dot.schemaspy.graph.Element;
import org.schemaspy.output.dot.schemaspy.node.Footer;
import org.schemaspy.output.dot.schemaspy.node.footer.Children;
import org.schemaspy.output.dot.schemaspy.node.footer.Parents;
import org.schemaspy.output.dot.schemaspy.node.footer.Rows;
import org.schemaspy.util.naming.Name;
import org.schemaspy.util.naming.NameFromString;
import org.schemaspy.util.naming.SanitizedFileName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DotNode
implements Node {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Html html = new Html();
    private static final String INDENT_6 = "      ";
    private static final String TABLES_PATH = "/tables/";
    private final Table table;
    private final String path;
    private final DotNodeConfig config;
    private final RuntimeDotConfig runtimeDotConfig;
    private final String lineSeparator = System.getProperty("line.separator");
    private final String columnSpan;
    private boolean showImpliedRelationships;

    public DotNode(Table table, boolean fromRoot, DotNodeConfig config, RuntimeDotConfig runtimeDotConfig) {
        this.table = table;
        this.config = config;
        this.runtimeDotConfig = runtimeDotConfig;
        this.path = this.createPath(fromRoot);
        this.columnSpan = config.showColumnDetails ? "COLSPAN=\"2\" " : "COLSPAN=\"3\" ";
    }

    private String createPath(boolean fromRoot) {
        if (this.runtimeDotConfig.useRelativeLinks()) {
            return (String)(this.table.isRemote() ? "../../../" + new SanitizedFileName((Name)new NameFromString(this.table.getContainer())).value() : "../..") + "/tables/";
        }
        if (fromRoot) {
            return this.table.isRemote() ? "../" + new SanitizedFileName((Name)new NameFromString(this.table.getContainer())).value() + "/tables/" : "tables/";
        }
        return this.table.isRemote() ? "../../" + new SanitizedFileName((Name)new NameFromString(this.table.getContainer())).value() + "/tables/" : "";
    }

    public void setShowImplied(boolean showImplied) {
        this.showImpliedRelationships = showImplied;
    }

    public Table getTable() {
        return this.table;
    }

    public String value() {
        return this.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String tableName = this.table.getName();
        String fqTableName = (String)(this.table.isRemote() ? this.table.getContainer() + "." : "") + tableName;
        int maxTitleWidth = this.getTitleMaxWidth(fqTableName);
        String columnSpanForHeaderAndFooter = this.config.showColumnDetails ? "COLSPAN=\"4\" " : "COLSPAN=\"3\" ";
        String tableOrView = this.table.isView() ? "view" : "table";
        buf.append("  \"" + fqTableName + "\" [" + this.lineSeparator);
        buf.append("   label=<" + this.lineSeparator);
        buf.append("    <TABLE BORDER=\"" + (this.config.showColumnDetails ? "2" : "0") + "\" CELLBORDER=\"1\" CELLSPACING=\"0\" BGCOLOR=\"" + this.runtimeDotConfig.styleSheet().getTableBackground() + "\">" + this.lineSeparator);
        buf.append("      <TR>");
        buf.append("<TD " + columnSpanForHeaderAndFooter + " BGCOLOR=\"" + this.runtimeDotConfig.styleSheet().getTableHeadBackground() + "\">");
        buf.append("<TABLE BORDER=\"0\" CELLSPACING=\"0\">");
        buf.append("<TR>");
        buf.append("<TD ALIGN=\"LEFT\" FIXEDSIZE=\"TRUE\" WIDTH=\"" + maxTitleWidth + "\" HEIGHT=\"16\"><B>" + DotNode.escapeHtml((String)fqTableName) + "</B></TD>");
        buf.append("<TD ALIGN=\"RIGHT\">[" + tableOrView + "]</TD>");
        buf.append("</TR>");
        buf.append("</TABLE>");
        buf.append("</TD>");
        buf.append("</TR>" + this.lineSeparator);
        buf.append(this.columnsToString());
        if (!this.table.isView()) {
            buf.append(this.footerToString(columnSpanForHeaderAndFooter));
        }
        buf.append("    </TABLE>>" + this.lineSeparator);
        if (!this.table.isRemote() || this.runtimeDotConfig.isOneOfMultipleSchemas()) {
            buf.append("    URL=\"" + this.path + DotNode.urlEncodeLink((String)new SanitizedFileName((Name)new NameFromString(tableName)).value()) + ".html\"" + this.lineSeparator);
            buf.append("    target=\"_top\"" + this.lineSeparator);
        }
        buf.append("    tooltip=\"" + DotNode.escapeHtml((String)fqTableName) + "\"" + this.lineSeparator);
        buf.append("  ];");
        return buf.toString();
    }

    private String columnsToString() {
        StringBuilder buf = new StringBuilder();
        boolean skippedTrivial = false;
        if (this.config.showColumns) {
            Set indexColumns = this.getIndexColumns();
            int maxWidth = this.getColumnMaxWidth();
            for (TableColumn column : this.table.getColumns()) {
                if (this.config.showTrivialColumns || this.config.showColumnDetails || column.isPrimary() || column.isForeignKey() || indexColumns.contains(column)) {
                    buf.append(this.columnToString(column, indexColumns, maxWidth));
                    continue;
                }
                skippedTrivial = true;
            }
        }
        if (skippedTrivial || !this.config.showColumns) {
            buf.append("      <TR><TD PORT=\"elipses\" COLSPAN=\"3\" ALIGN=\"LEFT\">...</TD></TR>" + this.lineSeparator);
        }
        return buf.toString();
    }

    private Set<TableColumn> getIndexColumns() {
        LinkedHashSet<TableColumn> indexColumns = new LinkedHashSet<TableColumn>();
        for (TableIndex index : this.table.getIndexes()) {
            indexColumns.addAll(index.getColumns());
        }
        indexColumns.removeAll(this.table.getPrimaryColumns());
        return indexColumns;
    }

    private int getTitleMaxWidth(String titleTable) {
        return this.getTextWidth(titleTable);
    }

    private int getColumnMaxWidth() {
        int maxWidth = this.getTextWidth(this.table.getName());
        for (TableColumn column : this.table.getColumns()) {
            int size = this.getTextWidth(column.getName());
            if (maxWidth >= size) continue;
            maxWidth = size;
        }
        return maxWidth;
    }

    private int getTextWidth(String text) {
        return this.runtimeDotConfig.getTextWidth(text);
    }

    private String columnToString(TableColumn column, Set<TableColumn> indexColumns, int maxWidth) {
        StringBuilder buf = new StringBuilder();
        buf.append("      <TR>");
        buf.append("<TD PORT=\"" + DotNode.escapeHtml((String)column.getName()) + "\" " + this.columnSpan);
        buf.append(this.getColumnBackground(column.isExcluded(), indexColumns.contains(column)));
        buf.append("ALIGN=\"LEFT\">");
        buf.append("<TABLE BORDER=\"0\" CELLSPACING=\"0\" ALIGN=\"LEFT\">");
        buf.append("<TR ALIGN=\"LEFT\">");
        buf.append("<TD ALIGN=\"LEFT\" FIXEDSIZE=\"TRUE\" WIDTH=\"15\" HEIGHT=\"16\">");
        buf.append(this.getKeyIcon(column));
        buf.append("</TD>");
        buf.append("<TD ALIGN=\"LEFT\" FIXEDSIZE=\"TRUE\" WIDTH=\"" + maxWidth + "\" HEIGHT=\"16\">");
        buf.append(DotNode.escapeHtml((String)column.getName()));
        buf.append("</TD>");
        buf.append("</TR>");
        buf.append("</TABLE>");
        buf.append("</TD>");
        if (this.config.showColumnDetails) {
            buf.append("<TD PORT=\"");
            buf.append(DotNode.escapeHtml((String)column.getName()));
            buf.append(".type\" ALIGN=\"LEFT\">");
            buf.append(DotNode.escapeHtml((String)column.getShortTypeName().toLowerCase()));
            if (Objects.nonNull(column.getDetailedSize()) && !column.getDetailedSize().isEmpty()) {
                buf.append("[");
                buf.append(DotNode.escapeHtml((String)column.getDetailedSize()));
                buf.append("]");
            }
            buf.append("</TD>");
        }
        buf.append("</TR>" + this.lineSeparator);
        return buf.toString();
    }

    private String getColumnBackground(boolean isExcluded, boolean isIndex) {
        if (isExcluded) {
            return "BGCOLOR=\"" + this.runtimeDotConfig.styleSheet().getExcludedColumnBackgroundColor() + "\" ";
        }
        if (isIndex) {
            return "BGCOLOR=\"" + this.runtimeDotConfig.styleSheet().getIndexedColumnBackground() + "\" ";
        }
        return "";
    }

    private String getKeyIcon(TableColumn column) {
        if (column.isPrimary()) {
            return "<IMG SRC=\"../../images/primaryKeys.png\"/>";
        }
        if (column.isForeignKey()) {
            return "<IMG SRC=\"../../images/foreignKeys.png\"/>";
        }
        return "";
    }

    private String footerToString(String columnSpan) {
        StringBuilder buf = new StringBuilder();
        buf.append("      <TR>");
        buf.append("<TD ALIGN=\"LEFT\" CELLPADDING=\"0\" BGCOLOR=\"" + this.runtimeDotConfig.styleSheet().getBodyBackground() + "\" " + columnSpan + ">");
        buf.append(new Footer(this.runtimeDotConfig.styleSheet().getBodyBackground(), (Element)new Parents(this.showImpliedRelationships ? this.table.getNumParents() : this.table.getNumNonImpliedParents(), this.config.showColumnDetails), (Element)new Rows(this.table.getNumRows(), this.runtimeDotConfig.isNumRowsEnabled()), (Element)new Children(this.showImpliedRelationships ? this.table.getNumChildren() : this.table.getNumNonImpliedChildren(), this.config.showColumnDetails)).value());
        buf.append("</TD></TR>" + this.lineSeparator);
        return buf.toString();
    }

    private static String escapeHtml(String string) {
        return html.escape(string);
    }

    private static String urlEncodeLink(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Error trying to urlEncode string [{}] with encoding [{}]", new Object[]{string, StandardCharsets.UTF_8.name(), e});
            return string;
        }
    }
}

