/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.concurrent.atomic.LongAdder;
import org.schemaspy.model.Database;
import org.schemaspy.model.Table;
import org.schemaspy.output.dot.RuntimeDotConfig;
import org.schemaspy.output.dot.schemaspy.DotSummaryFormatter;
import org.schemaspy.output.dot.schemaspy.relationship.ImpliedRelationships;
import org.schemaspy.output.dot.schemaspy.relationship.RealRelationships;

public class DotFormatter {
    private final RuntimeDotConfig runtimeDotConfig;
    private final DotSummaryFormatter dotSummaryFormatter;

    public DotFormatter(RuntimeDotConfig runtimeDotConfig, boolean includeOrphans) {
        this.runtimeDotConfig = runtimeDotConfig;
        this.dotSummaryFormatter = new DotSummaryFormatter(runtimeDotConfig, includeOrphans);
    }

    public void writeSummaryRealRelationships(Database db, Collection<Table> tables, boolean compact, PrintWriter dot) {
        this.dotSummaryFormatter.writeSummaryRealRelationships(db, tables, compact, dot);
    }

    public void writeSummaryAllRelationships(Database db, Collection<Table> tables, boolean compact, PrintWriter dot) {
        this.dotSummaryFormatter.writeSummaryAllRelationships(db, tables, compact, dot);
    }

    public void writeTableRealRelationships(Table table, boolean twoDegreesOfSeparation, LongAdder stats, PrintWriter dot) {
        new RealRelationships(this.runtimeDotConfig, table, twoDegreesOfSeparation, stats, dot).write();
    }

    public void writeTableAllRelationships(Table table, boolean twoDegreesOfSeparation, LongAdder stats, PrintWriter dot) {
        new ImpliedRelationships(this.runtimeDotConfig, table, twoDegreesOfSeparation, stats, dot).write();
    }
}

