/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy;

import org.schemaspy.output.dot.RuntimeDotConfig;
import org.schemaspy.output.dot.schemaspy.Header;

public final class DotConfigHeader
implements Header {
    private final RuntimeDotConfig runtimeDotConfig;
    private final boolean showLabel;

    public DotConfigHeader(RuntimeDotConfig runtimeDotConfig, boolean showLabel) {
        this.runtimeDotConfig = runtimeDotConfig;
        this.showLabel = showLabel;
    }

    public String value() {
        StringBuilder header = new StringBuilder();
        header.append("  graph [");
        boolean rankdirbug = this.runtimeDotConfig.isRankDirBugEnabled();
        if (!rankdirbug) {
            header.append("    rankdir=\"RL\"");
        }
        header.append("    bgcolor=\"" + this.runtimeDotConfig.styleSheet().getBodyBackground() + "\"");
        if (this.showLabel) {
            if (rankdirbug) {
                header.append("    label=\"\\nLayout is significantly better without '-rankdirbug' option\"");
            } else {
                header.append("    label=\"\\nGenerated by SchemaSpy\"");
            }
            header.append("    labeljust=\"l\"");
        }
        header.append("    nodesep=\"0.18\"");
        header.append("    ranksep=\"0.46\"");
        header.append("    fontname=\"" + this.runtimeDotConfig.getFont() + "\"");
        header.append("    fontsize=\"" + this.runtimeDotConfig.getFontSize() + "\"");
        header.append("    packmode=\"graph\"");
        header.append("  ];");
        header.append("  node [");
        header.append("    fontname=\"" + this.runtimeDotConfig.getFont() + "\"");
        header.append("    fontsize=\"" + this.runtimeDotConfig.getFontSize() + "\"");
        header.append("    shape=\"plaintext\"");
        header.append("  ];");
        header.append("  edge [");
        header.append("    arrowsize=\"0.8\"");
        header.append("  ];");
        return header.toString();
    }
}

