/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.diagram.graphviz;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class GraphvizVersion
implements Comparable<GraphvizVersion> {
    private final List<Integer> segments = new ArrayList();
    private final String asString;
    private final int hashCode;

    public GraphvizVersion(String version) {
        this.asString = version;
        int hash = 0;
        if (version != null) {
            StringTokenizer tokenizer = new StringTokenizer(version, ". -_");
            while (tokenizer.hasMoreTokens()) {
                Integer segment = Integer.valueOf(tokenizer.nextToken());
                this.segments.add(segment);
                hash += segment.intValue();
            }
        }
        this.hashCode = hash;
    }

    @Override
    public int compareTo(GraphvizVersion other) {
        int size = Math.min(this.segments.size(), other.segments.size());
        for (int i = 0; i < size; ++i) {
            Integer otherSegment;
            Integer thisSegment = (Integer)this.segments.get(i);
            int result = thisSegment.compareTo(otherSegment = (Integer)other.segments.get(i));
            if (result == 0) continue;
            return result;
        }
        if (this.segments.size() == other.segments.size()) {
            return 0;
        }
        if (this.segments.size() > other.segments.size()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object other) {
        if (other instanceof GraphvizVersion) {
            return this.compareTo((GraphvizVersion)other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.asString;
    }
}

