/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.schemaspy.logging.Sanitize;
import org.schemaspy.output.diagram.Renderer;
import org.schemaspy.util.ManifestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class InfoHtml {
    private final File outputDir;
    private final Renderer renderer;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public InfoHtml(File outputDir, Renderer renderer) {
        this.outputDir = outputDir;
        this.renderer = renderer;
    }

    public void write() throws IOException {
        Path htmlInfoFile = this.outputDir.toPath().resolve("info-html.txt");
        Files.deleteIfExists(htmlInfoFile);
        InfoHtml.writeInfo((String)"date", (String)ZonedDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssZ")), (Path)htmlInfoFile);
        InfoHtml.writeInfo((String)"os", (String)(System.getProperty("os.name") + " " + System.getProperty("os.version")), (Path)htmlInfoFile);
        InfoHtml.writeInfo((String)"schemaspy-version", (String)ManifestUtils.getImplementationVersion(), (Path)htmlInfoFile);
        InfoHtml.writeInfo((String)"schemaspy-revision", (String)ManifestUtils.getImplementationRevision(), (Path)htmlInfoFile);
        InfoHtml.writeInfo((String)"renderer", (String)this.renderer.identifier(), (Path)htmlInfoFile);
    }

    private static void writeInfo(String key, String value, Path infoFile) {
        try {
            Files.write(infoFile, (key + "=" + value + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write '{}', to '{}={}'", new Object[]{new Sanitize(key), new Sanitize(value), infoFile, e});
        }
    }
}

