/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.model;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.schemaspy.input.dbms.xml.TableColumnMeta;
import org.schemaspy.input.dbms.xml.TableMeta;
import org.schemaspy.model.Database;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.model.TableIndex;
import org.schemaspy.util.CaseInsensitiveMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Table
implements Comparable<Table> {
    private final String catalog;
    private final String schema;
    private final String name;
    private final String fullName;
    private final String container;
    protected CaseInsensitiveMap<TableColumn> columns = new CaseInsensitiveMap();
    private final List<TableColumn> primaryKeys = new ArrayList();
    private final CaseInsensitiveMap<ForeignKeyConstraint> foreignKeys = new CaseInsensitiveMap();
    private final CaseInsensitiveMap<TableIndex> indexes = new CaseInsensitiveMap();
    private Object id;
    private final Map<String, String> checkConstraints = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private long numRows;
    protected final Database db;
    private String comments;
    private int maxChildren;
    private int maxParents;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Table(Database db, String catalog, String schema, String name, String comments) {
        this.db = db;
        this.catalog = catalog;
        this.schema = schema;
        this.container = Optional.ofNullable(schema).orElse(Optional.ofNullable(catalog).orElse(db.getName()));
        this.name = name;
        this.fullName = Table.getFullName((String)db.getName(), (String)catalog, (String)schema, (String)name);
        LOGGER.debug("Creating {} {}", (Object)this.getClass().getSimpleName(), (Object)this.fullName);
        this.setComments(comments);
    }

    public Collection<ForeignKeyConstraint> getForeignKeys() {
        return Collections.unmodifiableCollection(this.foreignKeys.values());
    }

    public CaseInsensitiveMap<ForeignKeyConstraint> getForeignKeysMap() {
        return this.foreignKeys;
    }

    public void addCheckConstraint(String constraintName, String text) {
        this.checkConstraints.put(constraintName, text);
    }

    public void setPrimaryColumn(TableColumn primaryColumn) {
        this.primaryKeys.add(primaryColumn);
    }

    protected TableColumn addColumn(TableColumnMeta colMeta) {
        TableColumn column = new TableColumn(this, colMeta);
        this.columns.put(column.getName(), (Object)column);
        return column;
    }

    public TableIndex getIndex(String indexName) {
        return (TableIndex)this.indexes.get((Object)indexName);
    }

    public CaseInsensitiveMap<TableIndex> getIndexesMap() {
        return this.indexes;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getContainer() {
        return this.container;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public static String getFullName(String db, String catalog, String schema, String table) {
        return (String)(catalog == null && schema == null ? db + "." : "") + (String)(catalog == null ? "" : catalog + ".") + (String)(schema == null ? "" : schema + ".") + table;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public Map<String, String> getCheckConstraints() {
        return this.checkConstraints;
    }

    public Set<TableIndex> getIndexes() {
        return new HashSet<TableIndex>(this.indexes.values());
    }

    public List<TableColumn> getPrimaryColumns() {
        return this.primaryKeys;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        String cmts;
        String string = cmts = comments == null || comments.trim().length() == 0 ? null : comments.trim();
        if (cmts != null) {
            int crapIndex = cmts.indexOf("; InnoDB free: ");
            if (crapIndex == -1) {
                int n = crapIndex = cmts.startsWith("InnoDB free: ") ? 0 : -1;
            }
            if (crapIndex != -1) {
                cmts = (cmts = cmts.substring(0, crapIndex).trim()).length() == 0 ? null : cmts;
            }
        }
        this.comments = cmts;
    }

    public TableColumn getColumn(String columnName) {
        return (TableColumn)this.columns.get((Object)columnName);
    }

    public List<TableColumn> getColumns() {
        TreeSet sorted = new TreeSet(new ByColumnIdComparator());
        sorted.addAll(this.columns.values());
        return new ArrayList<TableColumn>(sorted);
    }

    public void setColumns(CaseInsensitiveMap<TableColumn> columns) {
        this.columns = columns;
    }

    public CaseInsensitiveMap<TableColumn> getColumnsMap() {
        return this.columns;
    }

    public boolean isFloater() {
        return this.isLeaf() && this.isRoot();
    }

    public boolean isRoot() {
        for (TableColumn column : this.columns.values()) {
            if (!column.isForeignKey()) continue;
            return false;
        }
        return true;
    }

    public boolean isLeaf() {
        for (TableColumn column : this.columns.values()) {
            if (column.getChildren().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getMaxParents() {
        return this.maxParents;
    }

    public void addedParent() {
        ++this.maxParents;
    }

    public void unlinkParents() {
        for (TableColumn column : this.columns.values()) {
            column.unlinkParents();
        }
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void addedChild() {
        ++this.maxChildren;
    }

    public void unlinkChildren() {
        for (TableColumn column : this.columns.values()) {
            column.unlinkChildren();
        }
    }

    public ForeignKeyConstraint removeSelfReferencingConstraint() {
        return this.remove(this.getSelfReferencingConstraint());
    }

    private ForeignKeyConstraint remove(ForeignKeyConstraint constraint) {
        if (constraint != null) {
            for (int i = 0; i < constraint.getChildColumns().size(); ++i) {
                TableColumn childColumn = (TableColumn)constraint.getChildColumns().get(i);
                TableColumn parentColumn = (TableColumn)constraint.getParentColumns().get(i);
                childColumn.removeParent(parentColumn);
                parentColumn.removeChild(childColumn);
            }
        }
        return constraint;
    }

    private ForeignKeyConstraint getSelfReferencingConstraint() {
        for (TableColumn column : this.columns.values()) {
            for (TableColumn parentColumn : column.getParents()) {
                if (this.compareTo(parentColumn.getTable()) != 0) continue;
                return column.getParentConstraint(parentColumn);
            }
        }
        return null;
    }

    public List<ForeignKeyConstraint> removeNonRealForeignKeys() {
        ArrayList<ForeignKeyConstraint> nonReals = new ArrayList<ForeignKeyConstraint>();
        for (TableColumn column : this.columns.values()) {
            for (TableColumn parentColumn : column.getParents()) {
                ForeignKeyConstraint constraint = column.getParentConstraint(parentColumn);
                if (constraint == null || constraint.isReal()) continue;
                nonReals.add(constraint);
            }
        }
        for (ForeignKeyConstraint constraint : nonReals) {
            this.remove(constraint);
        }
        return nonReals;
    }

    public int getNumChildren() {
        int numChildren = 0;
        for (TableColumn column : this.columns.values()) {
            numChildren += column.getChildren().size();
        }
        return numChildren;
    }

    public int getNumNonImpliedChildren() {
        int numChildren = 0;
        for (TableColumn column : this.columns.values()) {
            for (TableColumn childColumn : column.getChildren()) {
                if (column.getChildConstraint(childColumn).isImplied()) continue;
                ++numChildren;
            }
        }
        return numChildren;
    }

    public int getNumParents() {
        int numParents = 0;
        for (TableColumn column : this.columns.values()) {
            numParents += column.getParents().size();
        }
        return numParents;
    }

    public int getNumNonImpliedParents() {
        int numParents = 0;
        for (TableColumn column : this.columns.values()) {
            for (TableColumn parentColumn : column.getParents()) {
                if (column.getParentConstraint(parentColumn).isImplied()) continue;
                ++numParents;
            }
        }
        return numParents;
    }

    public ForeignKeyConstraint removeAForeignKeyConstraint() {
        List sortedColumns = this.getColumns();
        int numParents = 0;
        int numChildren = 0;
        for (TableColumn column : sortedColumns) {
            numParents += column.getParents().size();
            numChildren += column.getChildren().size();
        }
        for (TableColumn column : sortedColumns) {
            ForeignKeyConstraint constraint = numParents <= numChildren ? column.removeAParentFKConstraint() : column.removeAChildFKConstraint();
            if (constraint == null) continue;
            return constraint;
        }
        return null;
    }

    public boolean isLogical() {
        return false;
    }

    public boolean isView() {
        return false;
    }

    public String getType() {
        return this.isView() ? "View" : "Table";
    }

    public boolean isRemote() {
        return false;
    }

    public String getViewDefinition() {
        return null;
    }

    public long getNumRows() {
        return this.numRows;
    }

    public void setNumRows(long numRows) {
        this.numRows = numRows;
    }

    public void update(TableMeta tableMeta) {
        String newComments = tableMeta.getComments();
        if (newComments != null) {
            this.comments = newComments;
        }
        for (TableColumnMeta colMeta : tableMeta.getColumns()) {
            TableColumn col = this.getColumn(colMeta.getName());
            if (col == null) {
                col = this.addColumn(colMeta);
            }
            col.update(colMeta);
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isOrphan(boolean withImpliedRelationships) {
        if (withImpliedRelationships) {
            return this.getMaxParents() == 0 && this.getMaxChildren() == 0;
        }
        for (TableColumn column : this.columns.values()) {
            for (TableColumn parentColumn : column.getParents()) {
                if (column.getParentConstraint(parentColumn).isImplied()) continue;
                return false;
            }
            for (TableColumn childColumn : column.getChildren()) {
                if (column.getChildConstraint(childColumn).isImplied()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(Table other) {
        if (other == this) {
            return 0;
        }
        return this.getFullName().compareToIgnoreCase(other.getFullName());
    }

    public boolean hasImpliedConstraints(int degreesOfSeparation) {
        if (degreesOfSeparation == 0) {
            return false;
        }
        for (TableColumn tableColumn2 : this.columns.values()) {
            if (!tableColumn2.hasImpliedConstraint()) continue;
            return true;
        }
        if (degreesOfSeparation > 1) {
            return this.columns.values().stream().flatMap(tableColumn -> Stream.concat(tableColumn.getParents().stream(), tableColumn.getChildren().stream())).map(TableColumn::getTable).distinct().anyMatch(table -> table.hasImpliedConstraints(degreesOfSeparation - 1));
        }
        return false;
    }
}

