/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.model;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.schemaspy.model.ProgressListener;
import org.schemaspy.model.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console
implements ProgressListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final File outputDirectory;
    private final ProgressListener origin;

    public Console(File outputDirectory, ProgressListener origin) {
        this.outputDirectory = outputDirectory;
        this.origin = origin;
    }

    public void startCollectingTablesViews() {
        this.origin.startCollectingTablesViews();
        LOGGER.info("Collecting schema information from database");
    }

    public void tableViewCollected(Table table) {
        this.origin.tableViewCollected(table);
        System.out.print('.');
    }

    public long finishedCollectingTablesViews() {
        long result = this.origin.finishedCollectingTablesViews();
        System.out.println();
        System.err.flush();
        System.out.flush();
        LOGGER.info("Collection of schema information finished after {} seconds", (Object)(result / 1000L));
        return result;
    }

    public void startConnectingTablesViews() {
        this.origin.startConnectingTablesViews();
        LOGGER.info("Connecting tables and views");
    }

    public void connectedTableView(Table table) {
        this.origin.connectedTableView(table);
        System.out.print('.');
    }

    public long finishedConnectingTablesViews() {
        long result = this.origin.finishedConnectingTablesViews();
        System.out.println();
        System.err.flush();
        System.out.flush();
        LOGGER.info("Tables and views connected after {} seconds", (Object)(result / 1000L));
        return result;
    }

    public void startCreatingSummaries() {
        this.origin.startCreatingSummaries();
        LOGGER.info("Writing/graphing summaries");
    }

    public void createdSummary() {
        this.origin.createdSummary();
        System.out.print('.');
    }

    public long finishedCreatingSummaries() {
        long result = this.origin.finishedCreatingSummaries();
        System.out.println();
        System.err.flush();
        System.out.flush();
        LOGGER.info("Summaries created after {} seconds", (Object)(result / 1000L));
        return result;
    }

    public void startCreatingTablePages() {
        this.origin.startCreatingTablePages();
        LOGGER.info("Creating table/view pages");
    }

    public void createdTablePage(Table table) {
        this.origin.createdTablePage(table);
        System.out.print('.');
    }

    public long finishedCreatingTablePages() {
        long result = this.origin.finishedCreatingTablePages();
        System.out.println();
        System.err.flush();
        System.out.flush();
        LOGGER.info("Created table/view pages after {} seconds", (Object)(result / 1000L));
        return result;
    }

    public long finished(Collection<Table> tables) {
        long result = this.origin.finished(tables);
        System.err.flush();
        System.out.flush();
        LOGGER.info("Wrote relationship details of {} tables/view to directory '{}' in {} seconds", new Object[]{tables.size(), this.outputDirectory, result / 1000L});
        return result;
    }
}

