/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.xml;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.schemaspy.input.dbms.xml.CmFacade;
import org.schemaspy.input.dbms.xml.TableColumnMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableMeta {
    private final String name;
    private final String comments;
    private final List<TableColumnMeta> columns = new ArrayList();
    private final String remoteCatalog;
    private final String remoteSchema;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    TableMeta(Node tableNode) {
        NamedNodeMap attribs = tableNode.getAttributes();
        this.name = attribs.getNamedItem("name").getNodeValue();
        this.comments = new CmFacade(tableNode).value();
        Node node = attribs.getNamedItem("remoteSchema");
        this.remoteSchema = node == null ? null : node.getNodeValue().trim();
        node = attribs.getNamedItem("remoteCatalog");
        this.remoteCatalog = node == null ? null : node.getNodeValue().trim();
        LOGGER.debug("Found XML table metadata for {} remoteCatalog: {} remoteSchema: {} comments: {}", new Object[]{this.name, this.remoteCatalog, this.remoteSchema, this.comments});
        NodeList columnNodes = ((Element)((Object)tableNode.getChildNodes())).getElementsByTagName("column");
        for (int i = 0; i < columnNodes.getLength(); ++i) {
            Node colNode = columnNodes.item(i);
            this.columns.add(new TableColumnMeta(colNode));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getComments() {
        return this.comments;
    }

    public List<TableColumnMeta> getColumns() {
        return this.columns;
    }

    public String getRemoteCatalog() {
        return this.remoteCatalog;
    }

    public String getRemoteSchema() {
        return this.remoteSchema;
    }
}

