/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.xml;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.schemaspy.input.dbms.xml.CmFacade;
import org.schemaspy.input.dbms.xml.ForeignKeyMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableColumnMeta {
    private final Node colNode;
    private final String name;
    private final boolean isPrimary;
    private final String comments;
    private final List<ForeignKeyMeta> foreignKeys = new ArrayList();
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public TableColumnMeta(Node colNode) {
        this.colNode = colNode;
        NamedNodeMap attribs = colNode.getAttributes();
        this.name = attribs.getNamedItem("name").getNodeValue();
        this.comments = new CmFacade(colNode).value();
        Node node = attribs.getNamedItem("primaryKey");
        this.isPrimary = node != null && this.evalBoolean(node.getNodeValue());
        LOGGER.debug("Found XML column metadata for {} isPrimaryKey: {} comments: {}", new Object[]{this.name, this.isPrimary, this.comments});
        NodeList fkNodes = ((Element)((Object)colNode.getChildNodes())).getElementsByTagName("foreignKey");
        for (int i = 0; i < fkNodes.getLength(); ++i) {
            Node fkNode = fkNodes.item(i);
            this.foreignKeys.add(new ForeignKeyMeta(fkNode));
        }
    }

    private boolean evalBoolean(String exp) {
        if (exp == null) {
            return false;
        }
        String returnExp = exp.trim().toLowerCase();
        return "true".equals(returnExp) || "yes".equals(returnExp) || "1".equals(returnExp);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        Node node = this.colNode.getAttributes().getNamedItem("type");
        return node == null ? "Unknown" : node.getNodeValue();
    }

    public String getId() {
        Node node = this.colNode.getAttributes().getNamedItem("id");
        return node == null ? null : node.getNodeValue();
    }

    public int getSize() {
        Node node = this.colNode.getAttributes().getNamedItem("size");
        return node == null ? 0 : Integer.parseInt(node.getNodeValue());
    }

    public int getDigits() {
        Node node = this.colNode.getAttributes().getNamedItem("digits");
        return node == null ? 0 : Integer.parseInt(node.getNodeValue());
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isNullable() {
        Node node = this.colNode.getAttributes().getNamedItem("nullable");
        return node != null && this.evalBoolean(node.getNodeValue());
    }

    public boolean isAutoUpdated() {
        Node node = this.colNode.getAttributes().getNamedItem("autoUpdated");
        return node != null && this.evalBoolean(node.getNodeValue());
    }

    public String getComments() {
        return this.comments;
    }

    public String getDefaultValue() {
        Node node = this.colNode.getAttributes().getNamedItem("defaultValue");
        return node == null ? null : node.getNodeValue();
    }

    public List<ForeignKeyMeta> getForeignKeys() {
        return this.foreignKeys;
    }

    public boolean isExcluded() {
        boolean isExcluded;
        NamedNodeMap attribs = this.colNode.getAttributes();
        Node node = attribs.getNamedItem("disableDiagramAssociations");
        if (node != null) {
            String tmp;
            switch (tmp = node.getNodeValue().trim().toLowerCase()) {
                case "all": 
                case "exceptdirect": {
                    isExcluded = true;
                    break;
                }
                default: {
                    isExcluded = false;
                    break;
                }
            }
        } else {
            isExcluded = false;
        }
        return isExcluded;
    }

    public boolean isAllExcluded() {
        boolean isAllExcluded;
        NamedNodeMap attribs = this.colNode.getAttributes();
        Node node = attribs.getNamedItem("disableDiagramAssociations");
        if (node != null) {
            String tmp;
            switch (tmp = node.getNodeValue().trim().toLowerCase()) {
                case "all": {
                    isAllExcluded = true;
                    break;
                }
                default: {
                    isAllExcluded = false;
                    break;
                }
            }
        } else {
            isAllExcluded = false;
        }
        return isAllExcluded;
    }

    public boolean isImpliedParentsDisabled() {
        boolean isImpliedParentsDisabled;
        NamedNodeMap attribs = this.colNode.getAttributes();
        Node node = attribs.getNamedItem("disableImpliedKeys");
        if (node != null) {
            String tmp;
            switch (tmp = node.getNodeValue().trim().toLowerCase()) {
                case "all": 
                case "from": {
                    isImpliedParentsDisabled = true;
                    break;
                }
                default: {
                    isImpliedParentsDisabled = false;
                    break;
                }
            }
        } else {
            isImpliedParentsDisabled = false;
        }
        return isImpliedParentsDisabled;
    }

    public boolean isImpliedChildrenDisabled() {
        boolean isImpliedChildrenDisabled;
        NamedNodeMap attribs = this.colNode.getAttributes();
        Node node = attribs.getNamedItem("disableImpliedKeys");
        if (node != null) {
            String tmp;
            switch (tmp = node.getNodeValue().trim().toLowerCase()) {
                case "all": 
                case "to": {
                    isImpliedChildrenDisabled = true;
                    break;
                }
                default: {
                    isImpliedChildrenDisabled = false;
                    break;
                }
            }
        } else {
            isImpliedChildrenDisabled = false;
        }
        return isImpliedChildrenDisabled;
    }
}

