/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service.name;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.schemaspy.input.dbms.service.name.DatabaseQuoted;
import org.schemaspy.model.DbmsMeta;
import org.schemaspy.util.naming.Name;

public class Sanitized
implements Name {
    private Pattern invalidIdentifierPattern;
    private DbmsMeta dbms;
    private final Name origin;

    public Sanitized(Pattern invalidIdentifierPattern, DbmsMeta dbms, Name origin) {
        this.invalidIdentifierPattern = invalidIdentifierPattern;
        this.dbms = dbms;
        this.origin = origin;
    }

    public String value() {
        String value = this.origin.value();
        Matcher matcher = this.invalidIdentifierPattern.matcher(value);
        boolean quotesRequired = matcher.find() || this.dbms.reservedWords().contains(value);
        DatabaseQuoted result = quotesRequired ? new DatabaseQuoted(this.dbms, this.origin) : this.origin;
        return result.value();
    }
}

