/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.schemaspy.connection.SqlConnection;
import org.schemaspy.input.dbms.service.DbmsService;
import org.schemaspy.input.dbms.service.InvalidIdentifierPattern;
import org.schemaspy.input.dbms.service.name.DatabaseQuoted;
import org.schemaspy.input.dbms.service.name.Sanitized;
import org.schemaspy.model.Database;
import org.schemaspy.model.DbmsMeta;
import org.schemaspy.model.InvalidConfigurationException;
import org.schemaspy.util.naming.EmptyName;
import org.schemaspy.util.naming.Name;
import org.schemaspy.util.naming.NameFromString;
import org.schemaspy.util.naming.Qualified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SqlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final DbmsService dbmsService = new DbmsService();
    private Connection connection;
    private DatabaseMetaData databaseMetaData;
    private DbmsMeta dbmsMeta;
    private Pattern invalidIdentifierPattern;

    public DatabaseMetaData connect(SqlConnection sqlConnection) throws SQLException, IOException {
        this.connection = sqlConnection.connection();
        this.databaseMetaData = this.connection.getMetaData();
        this.dbmsMeta = this.dbmsService.fetchDbmsMeta(this.databaseMetaData);
        this.invalidIdentifierPattern = new InvalidIdentifierPattern(this.databaseMetaData).pattern();
        return this.databaseMetaData;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DatabaseMetaData getDatabaseMetaData() {
        return this.databaseMetaData;
    }

    public DbmsMeta getDbmsMeta() {
        return this.dbmsMeta;
    }

    public PreparedStatement prepareStatement(String sql, Database db, String tableName) throws SQLException {
        StringBuilder sqlBuf = new StringBuilder(sql);
        List sqlParams = SqlService.getSqlParams((StringBuilder)sqlBuf, (String)db.getName(), (String)db.getCatalog().getName(), (String)db.getSchema().getName(), (String)tableName);
        LOGGER.debug("{} {}", (Object)sqlBuf, (Object)sqlParams);
        PreparedStatement stmt = this.connection.prepareStatement(sqlBuf.toString());
        try {
            for (int i = 0; i < sqlParams.size(); ++i) {
                stmt.setString(i + 1, (String)sqlParams.get(i));
            }
        }
        catch (SQLException exc) {
            stmt.close();
            throw exc;
        }
        return stmt;
    }

    private static List<String> getSqlParams(StringBuilder sql, String dbName, String catalog, String schema, String tableName) {
        HashMap<String, String> namedParams = new HashMap<String, String>();
        if (Objects.isNull(schema)) {
            schema = dbName;
        }
        namedParams.put(":dbname", dbName);
        namedParams.put(":schema", schema);
        namedParams.put(":owner", schema);
        if (Objects.nonNull(tableName)) {
            namedParams.put(":table", tableName);
            namedParams.put(":view", tableName);
        }
        if (Objects.nonNull(catalog)) {
            namedParams.put(":catalog", catalog);
        }
        ArrayList<String> sqlParams = new ArrayList<String>();
        int nextColon = sql.indexOf(":");
        while (nextColon != -1) {
            String paramName = new StringTokenizer(sql.substring(nextColon), " ,\"')").nextToken();
            String paramValue = (String)namedParams.get(paramName);
            if (Objects.isNull(paramValue)) {
                throw new InvalidConfigurationException("Unexpected named parameter '" + paramName + "' found in SQL '" + String.valueOf(sql) + "'");
            }
            sqlParams.add(paramValue);
            sql.replace(nextColon, nextColon + paramName.length(), "?");
            nextColon = sql.indexOf(":", nextColon);
        }
        return sqlParams;
    }

    public PreparedStatement prepareStatement(String sqlQuery) throws SQLException {
        return this.connection.prepareStatement(sqlQuery);
    }

    public String getQualifiedTableName(String catalog, String schema, String tableName, boolean forceQuotes) {
        String maybe = Optional.ofNullable(schema).orElse(catalog);
        EmptyName schemaOrCatalog = Objects.isNull(maybe) ? new EmptyName() : this.getSchemaOrCatalog((Name)new NameFromString(maybe), forceQuotes);
        Sanitized table = forceQuotes ? this.quoteIdentifier(tableName) : new Sanitized(this.invalidIdentifierPattern, this.dbmsMeta, (Name)new NameFromString(tableName));
        return new Qualified((Name)table, (Name)schemaOrCatalog).value();
    }

    private Name getSchemaOrCatalog(Name schemaOrCatalog, boolean forceQuotes) {
        return forceQuotes ? new DatabaseQuoted(this.dbmsMeta, schemaOrCatalog) : new Sanitized(this.invalidIdentifierPattern, this.dbmsMeta, schemaOrCatalog);
    }

    public Name quoteIdentifier(String id) {
        return new DatabaseQuoted(this.dbmsMeta, (Name)new NameFromString(id));
    }
}

