/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.regex.Pattern;

public class InvalidIdentifierPattern {
    private final DatabaseMetaData databaseMetaData;

    public InvalidIdentifierPattern(DatabaseMetaData databaseMetaData) {
        this.databaseMetaData = databaseMetaData;
    }

    public Pattern pattern() throws SQLException {
        StringBuilder validChars = new StringBuilder("a-zA-Z0-9_");
        String reservedRegexChars = "-&^";
        String extraValidChars = this.databaseMetaData.getExtraNameCharacters();
        for (int i = 0; i < extraValidChars.length(); ++i) {
            char ch = extraValidChars.charAt(i);
            if (reservedRegexChars.indexOf(ch) >= 0) {
                validChars.append("\\");
            }
            validChars.append(ch);
        }
        return Pattern.compile("[^" + String.valueOf(validChars) + "]");
    }
}

