/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.lang.invoke.MethodHandles;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.schemaspy.input.dbms.service.DbmsService;
import org.schemaspy.input.dbms.service.helper.UniformSet;
import org.schemaspy.input.dbms.service.keywords.Combined;
import org.schemaspy.input.dbms.service.keywords.Keywords;
import org.schemaspy.input.dbms.service.keywords.MetadataKeywords;
import org.schemaspy.input.dbms.service.keywords.Sql92Keywords;
import org.schemaspy.model.DbmsMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DbmsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public DbmsMeta fetchDbmsMeta(DatabaseMetaData databaseMetaData) {
        DbmsMeta.Builder builder = new DbmsMeta.Builder();
        DbmsService.onlyLogException(() -> builder.productName(databaseMetaData.getDatabaseProductName()));
        DbmsService.onlyLogException(() -> builder.productVersion(databaseMetaData.getDatabaseProductVersion()));
        builder.sqlKeywords((Keywords)new Combined((Keywords)new Sql92Keywords(), (Keywords)new MetadataKeywords(databaseMetaData)));
        DbmsService.onlyLogException(() -> builder.systemFunctions(new UniformSet(databaseMetaData.getSystemFunctions().split(",")).value()));
        DbmsService.onlyLogException(() -> builder.stringFunctions(new UniformSet(databaseMetaData.getStringFunctions().split(",")).value()));
        DbmsService.onlyLogException(() -> builder.numericFunctions(new UniformSet(databaseMetaData.getNumericFunctions().split(",")).value()));
        DbmsService.onlyLogException(() -> builder.timeDateFunctions(new UniformSet(databaseMetaData.getTimeDateFunctions().split(",")).value()));
        DbmsService.onlyLogException(() -> builder.identifierQuoteString(databaseMetaData.getIdentifierQuoteString().trim()));
        return builder.getDbmsMeta();
    }

    private static void onlyLogException(MetaDataFetcher fetcher) {
        try {
            fetcher.fetch();
        }
        catch (SQLException sqle) {
            LOGGER.warn("Failed to fetch metadata", (Throwable)sqle);
        }
    }
}

