/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.time.Clock;
import org.schemaspy.input.dbms.ProcessingConfig;
import org.schemaspy.input.dbms.service.ColumnService;
import org.schemaspy.input.dbms.service.DatabaseService;
import org.schemaspy.input.dbms.service.IndexService;
import org.schemaspy.input.dbms.service.RoutineService;
import org.schemaspy.input.dbms.service.SequenceService;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.input.dbms.service.TableService;
import org.schemaspy.input.dbms.service.ViewService;

public class DatabaseServiceFactory {
    private final Clock clock = Clock.systemDefaultZone();
    private final SqlService sqlService;

    public DatabaseServiceFactory(SqlService sqlService) {
        this.sqlService = sqlService;
    }

    public DatabaseService forSingleSchema(ProcessingConfig processingConfig) {
        return this.create(processingConfig, false);
    }

    public DatabaseService forMultipleSchemas(ProcessingConfig processingConfig) {
        return this.create(processingConfig, true);
    }

    private DatabaseService create(ProcessingConfig processingConfig, boolean multipleSchemas) {
        return new DatabaseService(this.clock, this.sqlService, processingConfig.isViewsEnabled(), processingConfig.getTableInclusions(), processingConfig.getTableExclusions(), processingConfig.getMaxDbThreads(), processingConfig.isExportedKeysEnabled(), processingConfig.isNumRowsEnabled(), processingConfig.getDatabaseTypeProperties(), new TableService(this.sqlService, processingConfig.isExportedKeysEnabled(), multipleSchemas, processingConfig.getTableInclusions(), processingConfig.getTableExclusions(), processingConfig.getDatabaseTypeProperties(), new ColumnService(this.sqlService, processingConfig.getIndirectColumnExclusions(), processingConfig.getColumnExclusions()), new IndexService(this.sqlService, processingConfig.getDatabaseTypeProperties())), new ViewService(this.sqlService, processingConfig.getDatabaseTypeProperties(), new ColumnService(this.sqlService, processingConfig.getIndirectColumnExclusions(), processingConfig.getColumnExclusions())), new RoutineService(this.sqlService, processingConfig.getDatabaseTypeProperties(), processingConfig.includeRoutineDefinition()), new SequenceService(this.sqlService, processingConfig.getDatabaseTypeProperties()));
    }
}

