/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.lang.invoke.MethodHandles;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.schemaspy.input.dbms.service.DatabaseService;
import org.schemaspy.input.dbms.service.DurationFormatter;
import org.schemaspy.input.dbms.service.RoutineService;
import org.schemaspy.input.dbms.service.SequenceService;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.input.dbms.service.TableService;
import org.schemaspy.input.dbms.service.ViewService;
import org.schemaspy.input.dbms.service.helper.BasicTableMeta;
import org.schemaspy.input.dbms.service.helper.RemoteTableIdentifier;
import org.schemaspy.input.dbms.xml.SchemaMeta;
import org.schemaspy.input.dbms.xml.TableMeta;
import org.schemaspy.model.Database;
import org.schemaspy.model.LogicalTable;
import org.schemaspy.model.ProgressListener;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.model.TableIndex;
import org.schemaspy.model.View;
import org.schemaspy.validator.NameValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatabaseService {
    private static final long THIRTY_MINUTES = 1800000L;
    private final Clock clock;
    private final SqlService sqlService;
    private final boolean viewsEnabled;
    private final Pattern include;
    private final Pattern exclude;
    private final int maxThreads;
    private final boolean exportedKeys;
    private final boolean numberOfRows;
    private final Properties dbProperties;
    private final TableService tableService;
    private final ViewService viewService;
    private final RoutineService routineService;
    private final SequenceService sequenceService;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public DatabaseService(Clock clock, SqlService sqlService, boolean viewsEnabled, Pattern tableInclusion, Pattern tableExclusion, int maxThreads, boolean exportedKeys, boolean numberOfRows, Properties dbProperties, TableService tableService, ViewService viewService, RoutineService routineService, SequenceService sequenceService) {
        this.clock = Objects.requireNonNull(clock);
        this.sqlService = Objects.requireNonNull(sqlService);
        this.viewsEnabled = viewsEnabled;
        this.include = tableInclusion;
        this.exclude = tableExclusion;
        this.maxThreads = maxThreads;
        this.exportedKeys = exportedKeys;
        this.numberOfRows = numberOfRows;
        this.dbProperties = dbProperties;
        this.tableService = Objects.requireNonNull(tableService);
        this.viewService = Objects.requireNonNull(viewService);
        this.routineService = Objects.requireNonNull(routineService);
        this.sequenceService = Objects.requireNonNull(sequenceService);
    }

    public void gatherSchemaDetails(Database db, SchemaMeta schemaMeta, ProgressListener listener) throws SQLException {
        listener.startCollectingTablesViews();
        DatabaseMetaData meta = this.sqlService.getDatabaseMetaData();
        this.initTables(db, listener, meta);
        if (this.viewsEnabled) {
            this.initViews(db, listener, meta);
        }
        this.initCatalogs(db);
        this.initSchemas(db);
        this.initCheckConstraints(db);
        this.tableService.gatherTableIds(db);
        this.initIndexIds(db);
        this.tableService.gatherTableComments(db);
        this.tableService.gatherTableColumnComments(db);
        this.viewService.gatherViewComments(db);
        this.viewService.gatherViewColumnComments(db);
        this.initColumnTypes(db);
        this.routineService.gatherRoutines(db);
        this.sequenceService.gatherSequences(db);
        listener.finishedCollectingTablesViews();
        listener.startConnectingTablesViews();
        this.connectTables(db, listener);
        this.updateFromXmlMetadata(db, schemaMeta);
        listener.finishedConnectingTablesViews();
    }

    private void initCatalogs(Database db) throws SQLException {
        String sql = this.dbProperties.getProperty("selectCatalogsSql");
        if (sql != null && db.getCatalog() != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    db.getCatalog().setComment(rs.getString("catalog_comment"));
                }
            }
            catch (SQLException sqlException) {
                LOGGER.error("Failed to retrieve comment for catalog '{}' using SQL '{}'", new Object[]{db.getCatalog().getName(), sql, sqlException});
            }
        }
    }

    private void initSchemas(Database db) throws SQLException {
        String sql = this.dbProperties.getProperty("selectSchemasSql");
        if (sql != null && db.getSchema() != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    db.getSchema().setComment(rs.getString("schema_comment"));
                }
            }
            catch (SQLException sqlException) {
                LOGGER.error("Failed to retrieve comment for schema '{}' using SQL '{}'", new Object[]{db.getSchema().getName(), sql, sqlException});
            }
        }
    }

    private void initTables(Database db, ProgressListener listener, DatabaseMetaData metadata) throws SQLException {
        TableCreator creator;
        String[] types = this.getTypes("tableTypes", "TABLE");
        NameValidator validator = new NameValidator("table", this.include, this.exclude, types);
        List entries = this.getBasicTableMeta(db, metadata, true, types);
        if (this.maxThreads == 1) {
            creator = new TableCreator(this);
        } else {
            creator = new ThreadedTableCreator(this, this.maxThreads);
            while (!entries.isEmpty()) {
                BasicTableMeta entry = (BasicTableMeta)entries.remove(0);
                if (!validator.isValid(entry.getName(), entry.getType())) continue;
                new TableCreator(this).create(db, entry, listener);
                break;
            }
        }
        for (BasicTableMeta entry : entries) {
            if (!validator.isValid(entry.getName(), entry.getType())) continue;
            creator.create(db, entry, listener);
        }
        creator.join();
    }

    private void initViews(Database db, ProgressListener listener, DatabaseMetaData metadata) throws SQLException {
        String[] types = this.getTypes("viewTypes", "VIEW");
        NameValidator validator = new NameValidator("view", this.include, this.exclude, types);
        for (BasicTableMeta entry : this.getBasicTableMeta(db, metadata, false, types)) {
            if (!validator.isValid(entry.getName(), entry.getType())) continue;
            View view = new View(db, entry.getCatalog(), entry.getSchema(), entry.getName(), entry.getRemarks(), entry.getViewDefinition());
            this.viewService.gatherViewsDetails(db, view);
            listener.tableViewCollected((Table)view);
            LOGGER.debug("Found details of view {}", (Object)view.getName());
        }
    }

    private String[] getTypes(String propName, String defaultValue) {
        String value = this.dbProperties.getProperty(propName, defaultValue);
        ArrayList<String> types = new ArrayList<String>();
        for (String type : value.split(",")) {
            if ((type = type.trim()).length() <= 0) continue;
            types.add(type);
        }
        return types.toArray(new String[types.size()]);
    }

    private void updateFromXmlMetadata(Database db, SchemaMeta schemaMeta) throws SQLException {
        Table table;
        if (Objects.isNull(schemaMeta)) {
            return;
        }
        if (Objects.nonNull(schemaMeta.getComments())) {
            db.getSchema().setComment(schemaMeta.getComments());
        }
        for (TableMeta tableMeta : schemaMeta.getTables()) {
            if (tableMeta.getRemoteSchema() != null || tableMeta.getRemoteCatalog() != null) {
                table = this.tableService.addLogicalRemoteTable(db, RemoteTableIdentifier.from((TableMeta)tableMeta), db.getSchema().getName());
            } else {
                table = (Table)db.getLocals().get(tableMeta.getName());
                if (table == null) {
                    table = new LogicalTable(db, db.getCatalog().getName(), db.getSchema().getName(), tableMeta.getName(), tableMeta.getComments());
                    db.getTablesMap().put(table.getName(), table);
                }
            }
            table.update(tableMeta);
        }
        for (TableMeta tableMeta : schemaMeta.getTables()) {
            table = tableMeta.getRemoteCatalog() != null || tableMeta.getRemoteSchema() != null ? (Table)db.getRemoteTablesMap().get(db.getRemoteTableKey(tableMeta.getRemoteCatalog(), tableMeta.getRemoteSchema(), tableMeta.getName())) : (Table)db.getLocals().get(tableMeta.getName());
            this.tableService.connect(db, table, tableMeta, db.getLocals());
        }
    }

    private void connectTables(Database db, ProgressListener listener) {
        Instant startTables = this.clock.instant();
        Duration durationOneTable = null;
        for (Table table : db.getTables()) {
            long timeLeft;
            listener.connectedTableView(table);
            this.tableService.connectForeignKeys(db, table, db.getLocals());
            if (!Objects.isNull(durationOneTable) || (timeLeft = (durationOneTable = Duration.between(startTables, this.clock.instant())).toMillis() * (long)(db.getTables().size() - 1)) <= 1800000L || !this.exportedKeys) continue;
            String remaining = DurationFormatter.formatMS((long)timeLeft);
            LOGGER.info("Estimated time remaining for connecting tables is {}, most time might be spent in getExportedKeys, you can disable getExportedKeys with `-noexportedkeys`. The implication of this is that you won't get cross schema relationships where table in analysis is FK, and the remote schema isn't analyzed", (Object)remaining);
        }
        Instant startViews = this.clock.instant();
        Duration durationOneView = null;
        for (Table view : db.getViews()) {
            long timeLeft;
            listener.connectedTableView(view);
            this.tableService.connectForeignKeys(db, view, db.getLocals());
            if (!Objects.isNull(durationOneView) || (timeLeft = (durationOneView = Duration.between(startViews, this.clock.instant())).toMillis() * (long)(db.getViews().size() - 1)) <= 1800000L || !this.exportedKeys) continue;
            String remaining = DurationFormatter.formatMS((long)timeLeft);
            LOGGER.info("Estimated time remaining for connecting views is {}, most time might be spent in getExportedKeys, you can disable getExportedKeys with `-noexportedkeys`. The implication of this is that you won't get cross schema relationships where table in analysis is FK, and the remote schema isn't analyzed", (Object)remaining);
        }
    }

    private List<BasicTableMeta> getBasicTableMeta(Database db, DatabaseMetaData metadata, boolean forTables, String ... types) throws SQLException {
        ArrayList<BasicTableMeta> basics = new ArrayList<BasicTableMeta>();
        if (!this.getBasicTableMetaFromSql(basics, db, forTables)) {
            DatabaseService.getBasicTableMetaFromDatabaseMetaData(basics, (DatabaseMetaData)metadata, (Database)db, (boolean)forTables, (String[])types);
        }
        return basics;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean getBasicTableMetaFromSql(List<BasicTableMeta> basics, Database database, boolean forTables) {
        String queryName = forTables ? "selectTablesSql" : "selectViewsSql";
        String sql = this.dbProperties.getProperty(queryName);
        if (sql != null) {
            String clazz = forTables ? "table" : "view";
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, database, null);){
                boolean bl;
                block16: {
                    ResultSet rs = stmt.executeQuery();
                    try {
                        while (rs.next()) {
                            basics.add(DatabaseService.basicTableMetaFromResultSetRow((ResultSet)rs, (boolean)forTables, (String)clazz, (String)database.getSchema().getName()));
                        }
                        bl = true;
                        if (rs == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return bl;
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve '{}' names with custom SQL '{}", new Object[]{clazz, sql, sqlException});
            }
        }
        basics.clear();
        return false;
    }

    private static BasicTableMeta basicTableMetaFromResultSetRow(ResultSet rs, boolean forTables, String clazz, String schemaName) throws SQLException {
        String name = rs.getString(clazz + "_name");
        String cat = DatabaseService.getOptionalString((ResultSet)rs, (String)(clazz + "_catalog"));
        String sch = DatabaseService.getOptionalString((ResultSet)rs, (String)(clazz + "_schema"));
        if (cat == null && sch == null) {
            sch = schemaName;
        }
        String remarks = DatabaseService.getOptionalString((ResultSet)rs, (String)(clazz + "_comment"));
        String viewDefinition = forTables ? null : DatabaseService.getOptionalString((ResultSet)rs, (String)"view_definition");
        String rows = forTables ? DatabaseService.getOptionalString((ResultSet)rs, (String)"table_rows") : null;
        long numRows = rows == null ? -1L : Long.parseLong(rows);
        return new BasicTableMeta(cat, sch, name, clazz, remarks, viewDefinition, numRows);
    }

    private static void getBasicTableMetaFromDatabaseMetaData(List<BasicTableMeta> basics, DatabaseMetaData databaseMetaData, Database database, boolean forTables, String ... types) throws SQLException {
        String lastTableName = null;
        try (ResultSet rs = databaseMetaData.getTables(null, database.getSchema().getName(), "%", types);){
            while (rs.next()) {
                String name;
                lastTableName = name = rs.getString("TABLE_NAME");
                String type = rs.getString("TABLE_TYPE");
                String cat = rs.getString("TABLE_CAT");
                String schem = rs.getString("TABLE_SCHEM");
                String remarks = DatabaseService.getOptionalString((ResultSet)rs, (String)"REMARKS");
                basics.add(new BasicTableMeta(cat, schem, name, type, remarks, null, -1L));
            }
        }
        catch (SQLException exc) {
            if (forTables) {
                throw exc;
            }
            LOGGER.warn("Ignoring view '{}' due to exception", lastTableName, (Object)exc);
        }
    }

    private static String getOptionalString(ResultSet rs, String columnName) {
        try {
            return rs.getString(columnName);
        }
        catch (SQLException ignore) {
            return null;
        }
    }

    private void initCheckConstraints(Database db) {
        String sql = this.dbProperties.getProperty("selectCheckConstraintsSql");
        boolean append = Boolean.parseBoolean(this.dbProperties.getProperty("multirowdata", "false"));
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String tableName = rs.getString("table_name");
                    Table table = (Table)db.getLocals().get(tableName);
                    if (table == null) continue;
                    if (append) {
                        table.getCheckConstraints().merge(rs.getString("constraint_name"), rs.getString("text"), (oldValue, newValue) -> oldValue + newValue);
                        continue;
                    }
                    table.getCheckConstraints().put(rs.getString("constraint_name"), rs.getString("text"));
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve check constraints using SQL '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }

    private void initColumnTypes(Database db) {
        String sql = this.dbProperties.getProperty("selectColumnTypesSql");
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String columnName;
                    TableColumn column;
                    String tableName = rs.getString("table_name");
                    Table table = (Table)db.getLocals().get(tableName);
                    if (table == null || (column = table.getColumn(columnName = rs.getString("column_name"))) == null) continue;
                    column.setTypeName(rs.getString("column_type"));
                    column.setShortType(DatabaseService.getOptionalString((ResultSet)rs, (String)"short_column_type"));
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve column type details using SQL '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }

    private void initIndexIds(Database db) throws SQLException {
        String sql = this.dbProperties.getProperty("selectIndexIdsSql");
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    TableIndex index;
                    String tableName = rs.getString("table_name");
                    Table table = (Table)db.getLocals().get(tableName);
                    if (table == null || (index = table.getIndex(rs.getString("index_name"))) == null) continue;
                    index.setId(rs.getObject("index_id"));
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to fetch index ids using SQL '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }
}

