/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.driverclass;

import java.lang.invoke.MethodHandles;
import java.sql.Driver;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.schemaspy.input.dbms.classloader.ClSticky;
import org.schemaspy.input.dbms.classloader.ClassloaderSource;
import org.schemaspy.input.dbms.driverclass.DcClassloader;
import org.schemaspy.input.dbms.driverclass.DcErrorLogged;
import org.schemaspy.input.dbms.driverclass.DcIterator;
import org.schemaspy.input.dbms.driverclass.Driverclass;
import org.schemaspy.input.dbms.exceptions.ConnectionFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcFacade
implements Driverclass {
    private final Logger logger;
    private final String[] driverClasses;
    private final ClassloaderSource loader;

    public DcFacade(String[] driverClasses, ClassloaderSource loader) {
        this(LoggerFactory.getLogger(MethodHandles.lookup().lookupClass()), driverClasses, loader);
    }

    public DcFacade(Logger logger, String[] driverClasses, ClassloaderSource loader) {
        this.logger = logger;
        this.driverClasses = driverClasses;
        this.loader = new ClSticky(loader);
    }

    public Class<Driver> value() {
        Class result;
        List candidates = Arrays.stream(this.driverClasses).map(candidate -> new DcErrorLogged((Driverclass)new DcClassloader(candidate, this.loader.classloader()))).collect(Collectors.toList());
        try {
            result = new DcIterator(candidates.iterator()).value();
        }
        catch (NoSuchElementException e) {
            throw new ConnectionFailure(String.format("Failed to create any of '%s' driver from driver path.", String.join((CharSequence)", ", this.driverClasses)));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Using driver '%s'", result.getName()));
        }
        return result;
    }
}

