/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Properties;
import java.util.regex.Pattern;
import org.schemaspy.cli.NoRowsConfigCli;
import org.schemaspy.cli.PatternConverter;
import org.schemaspy.input.dbms.DatabaseTypeConfig;
import org.schemaspy.input.dbms.ProcessingConfig;

@Parameters(resourceBundle="processingconfigcli")
public class ProcessingConfigCli
implements ProcessingConfig {
    @Parameter(names={"-noexportedkeys", "--no-exported-keys", "schemaspy.noexportedkeys", "schemaspy.no-exported-keys"}, descriptionKey="noexportedkeys")
    private boolean noExportedKeys = false;
    @Parameter(names={"-noviews", "--no-views", "schemaspy.noviews", "schemaspy.no-views"}, descriptionKey="noviews")
    private boolean noViews = false;
    @Parameter(names={"-X", "--column-exclusions", "schemaspy.X", "schemaspy.columnExclusions", "schemaspy.column-exclusions"}, descriptionKey="columnexclusion", converter=PatternConverter.class)
    private Pattern columnExclusions = Pattern.compile("[^.]");
    @Parameter(names={"-x", "--indirect-column-exclusions", "schemaspy.x", "schemaspy.indirectColumnExclusions", "schemaspy.indirect-column-exclusions"}, descriptionKey="indirectcolumnexclusions", converter=PatternConverter.class)
    private Pattern indirectColumnExclusions = Pattern.compile("[^.]");
    @Parameter(names={"-i", "--table-inclusions", "schemaspy.i", "schemaspy.tableInclusions", "schemaspy.table-inclusions"}, descriptionKey="tableinclusions", converter=PatternConverter.class)
    private Pattern tableInclusions = Pattern.compile(".*");
    @Parameter(names={"-I", "--table-exclusions", "schemaspy.I", "schemaspy.tableExclusions", "schemaspy.table-exclusions"}, descriptionKey="tableexclusions", converter=PatternConverter.class)
    private Pattern tableExclusions = Pattern.compile(".*\\$.*");
    @Parameter(names={"-dbThreads", "-dbthreads", "--db-threads", "schemaspy.dbthreads", "schemaspy.dbThreads", "schemaspy.db-threads"}, descriptionKey="maxdbthreads")
    private int maxDbThreads = 0;
    @Parameter(names={"--include-routine-definition", "schemaspy.includeRoutineDefinition"}, descriptionKey="includeroutinedefinition")
    private boolean includeRoutineDefinition = false;
    private final NoRowsConfigCli noRowsConfigCli;
    private final DatabaseTypeConfig databaseTypeConfig;

    public ProcessingConfigCli(NoRowsConfigCli noRowsConfigCli, DatabaseTypeConfig databaseTypeConfig) {
        this.noRowsConfigCli = noRowsConfigCli;
        this.databaseTypeConfig = databaseTypeConfig;
    }

    public String getDatabaseType() {
        return this.databaseTypeConfig.getType();
    }

    public Properties getDatabaseTypeProperties() {
        return this.databaseTypeConfig.getProperties();
    }

    public boolean isExportedKeysEnabled() {
        return !this.noExportedKeys;
    }

    public boolean isNumRowsEnabled() {
        return this.noRowsConfigCli.isNumRowsEnabled();
    }

    public boolean isViewsEnabled() {
        return !this.noViews;
    }

    public Pattern getColumnExclusions() {
        return this.columnExclusions;
    }

    public Pattern getIndirectColumnExclusions() {
        return this.indirectColumnExclusions;
    }

    public Pattern getTableInclusions() {
        return this.tableInclusions;
    }

    public Pattern getTableExclusions() {
        return this.tableExclusions;
    }

    public int getMaxDbThreads() {
        if (this.maxDbThreads != 0) {
            return this.maxDbThreads;
        }
        if (this.getDatabaseTypeProperties().containsKey("dbThreads")) {
            return Integer.parseInt(this.getDatabaseTypeProperties().getProperty("dbThreads"));
        }
        if (this.getDatabaseTypeProperties().containsKey("dbthreads")) {
            return Integer.parseInt(this.getDatabaseTypeProperties().getProperty("dbthreads"));
        }
        return Math.min(Runtime.getRuntime().availableProcessors(), 15);
    }

    public boolean includeRoutineDefinition() {
        return this.includeRoutineDefinition;
    }
}

