/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.connection;

import java.io.IOException;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.schemaspy.connection.Connection;
import org.schemaspy.connection.PreferencesConnection;
import org.schemaspy.connection.SqlConnection;
import org.schemaspy.connection.WithPassword;
import org.schemaspy.connection.WithUser;
import org.schemaspy.input.dbms.ConnectionConfig;
import org.schemaspy.input.dbms.ConnectionURLBuilder;
import org.schemaspy.input.dbms.driver.Driversource;

public final class ScSimple
implements SqlConnection {
    private final Connection con;
    private final ConnectionURLBuilder urlBuilder;
    private final Driversource driversource;

    public ScSimple(ConnectionConfig connectionConfig, ConnectionURLBuilder urlBuilder, Driversource driversource) {
        this((Connection)new WithPassword(connectionConfig.getPassword(), (Connection)new WithUser(connectionConfig.getUser(), (Connection)new PreferencesConnection(connectionConfig.getConnectionProperties()))), urlBuilder, driversource);
    }

    public ScSimple(Connection con, ConnectionURLBuilder urlBuilder, Driversource driversource) {
        this.con = con;
        this.urlBuilder = urlBuilder;
        this.driversource = driversource;
    }

    public java.sql.Connection connection() throws IOException, SQLException {
        String connectionURL = this.urlBuilder.build();
        Properties connectionProperties = this.con.properties();
        Driver driver = this.driversource.driver();
        return driver.connect(connectionURL, connectionProperties);
    }
}

