/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.cli;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import java.util.Arrays;
import org.schemaspy.SchemaAnalyzer;
import org.schemaspy.cli.CommandLineArguments;
import org.schemaspy.input.dbms.MissingParameterException;
import org.schemaspy.input.dbms.exceptions.ConnectionFailure;
import org.schemaspy.model.EmptySchemaException;
import org.schemaspy.model.InvalidConfigurationException;
import org.schemaspy.util.DbSpecificConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSpyRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int EXIT_CODE_OK = 0;
    private static final int EXIT_CODE_GENERIC_ERROR = 1;
    private static final int EXIT_CODE_EMPTY_SCHEMA = 2;
    private static final int EXIT_CODE_CONNECTION_ERROR = 3;
    private static final int EXIT_CODE_CONFIG_ERROR = 4;
    private static final int EXIT_CODE_MISSING_PARAMETER = 5;
    private static final int EXIT_CODE_SQL_EXCEPTION = 6;
    private static final int EXIT_IO_ERROR = 7;
    private final SchemaAnalyzer analyzer;
    private final CommandLineArguments arguments;
    private final String[] args;

    public SchemaSpyRunner(SchemaAnalyzer analyzer, CommandLineArguments arguments, String ... args) {
        this.analyzer = analyzer;
        this.arguments = arguments;
        this.args = args;
    }

    public int run() {
        try {
            return this.analyzer.analyze() == null ? 1 : 0;
        }
        catch (ConnectionFailure couldntConnect) {
            LOGGER.warn("Connection Failure", (Throwable)couldntConnect);
            return 3;
        }
        catch (EmptySchemaException noData) {
            LOGGER.warn("Empty schema");
            return 2;
        }
        catch (InvalidConfigurationException badConfig) {
            LOGGER.debug("Command line parameters: {}", Arrays.asList(this.args));
            if (badConfig.getParamName() != null) {
                LOGGER.error("Bad parameter: '{} = {}'", new Object[]{badConfig.getParamName(), badConfig.getParamValue(), badConfig});
            } else {
                LOGGER.error("Bad config", (Throwable)badConfig);
            }
            return 4;
        }
        catch (MissingParameterException mrpe) {
            LOGGER.error("*** {} ***", (Object)mrpe.getMessage());
            LOGGER.info("Missing required connection parameters for '-t {}'", (Object)this.arguments.getConnectionConfig().getDatabaseType());
            new DbSpecificConfig(this.arguments.getConnectionConfig().getDatabaseType(), this.arguments.getConnectionConfig().getDatabaseTypeProperties()).dumpUsage(LOGGER);
            return 5;
        }
        catch (SQLException e) {
            LOGGER.error("SqlException", (Throwable)e);
            return 6;
        }
        catch (IOException e) {
            LOGGER.error("IOException", (Throwable)e);
            return 7;
        }
    }
}

