/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.schemaspy.cli.DegreeOfSeparationValidator;
import org.schemaspy.cli.NoRowsConfigCli;
import org.schemaspy.cli.SchemasListConverter;
import org.schemaspy.cli.TemplateDirectoryConfigCli;
import org.schemaspy.input.dbms.ConnectionConfig;
import org.schemaspy.input.dbms.ConnectionConfigCli;
import org.schemaspy.input.dbms.DatabaseTypeConfig;
import org.schemaspy.input.dbms.DatabaseTypeConfigCli;
import org.schemaspy.input.dbms.ProcessingConfig;
import org.schemaspy.input.dbms.ProcessingConfigCli;
import org.schemaspy.input.dbms.config.PropertiesResolver;
import org.schemaspy.input.dbms.config.SimplePropertiesResolver;
import org.schemaspy.output.diagram.graphviz.GraphvizConfig;
import org.schemaspy.output.diagram.graphviz.GraphvizConfigCli;
import org.schemaspy.output.dot.DotConfig;
import org.schemaspy.output.dot.DotConfigCli;
import org.schemaspy.view.HtmlConfig;
import org.schemaspy.view.HtmlConfigCli;

@Parameters(resourceBundle="commandlinearguments")
public class CommandLineArguments {
    @Parameter(names={"?", "-?", "/?", "-h", "-help", "--help"}, descriptionKey="help", help=true, order=1)
    private boolean helpRequired;
    @Parameter(names={"-dbHelp", "-dbhelp", "--dbHelp", "--dbhelp"}, help=true, descriptionKey="dbhelp", order=2)
    private boolean dbHelpRequired;
    @Parameter(names={"-l", "--license"}, help=true, descriptionKey="license", order=3)
    private boolean printLicense;
    @Parameter(names={"-debug", "--debug", "schemaspy.debug"}, descriptionKey="debug")
    private boolean debug = false;
    @Parameter(names={"-nohtml", "--no-html", "schemaspy.nohtml"}, descriptionKey="nohtml")
    private boolean nohtml = false;
    @Parameter(names={"-noimplied", "--no-implied", "schemaspy.noimplied"}, descriptionKey="noimplied")
    private boolean noImplied = false;
    @Parameter(names={"--no-orphans", "schemaspy.no-orphans"}, descriptionKey="noorphans")
    private boolean noOrphans = false;
    @Parameter(names={"-rails", "schemaspy.rails"}, descriptionKey="rails")
    private boolean railsEnabled = false;
    @Parameter(names={"-meta", "--schema-meta", "schemaspy.meta"}, descriptionKey="meta")
    private String schemaMeta;
    @Parameter(names={"-sso", "--single-sign-on", "schemaspy.sso", "schemaspy.single-sign-on"}, descriptionKey="sso")
    private boolean sso = false;
    @Parameter(names={"-s", "--schema", "schemaspy.s", "schemaspy.schema"}, descriptionKey="schema")
    private String schema;
    @Parameter(names={"-cat", "--catalog", "schemaspy.cat", "schemaspy.catalog"}, descriptionKey="catalog")
    private String catalog;
    @Parameter(names={"-all", "schemaspy.all"}, descriptionKey="all")
    private boolean evaluateAllEnabled = false;
    @Parameter(names={"-schemaSpec", "--schema-spec", "schemaspy.schemaSpec", "schemaspy.schema-spec"}, descriptionKey="schemaspec")
    private String schemaSpec;
    @Parameter(names={"-schemas", "-schemata", "schemaspy.schemas", "schemaspy.schemata"}, descriptionKey="schemas", converter=SchemasListConverter.class)
    private Set<String> schemas = new HashSet();
    @Parameter(names={"-o", "--outputDirectory", "schemaspy.o", "schemaspy.outputDirectory"}, descriptionKey="outputDirectory")
    private File outputDirectory;
    @ParametersDelegate
    private GraphvizConfigCli graphvizConfig = new GraphvizConfigCli();
    @ParametersDelegate
    private NoRowsConfigCli noRowsConfigCli = new NoRowsConfigCli();
    @ParametersDelegate
    private DatabaseTypeConfigCli databaseTypeConfigCli = new DatabaseTypeConfigCli((PropertiesResolver)new SimplePropertiesResolver());
    @ParametersDelegate
    private ConnectionConfigCli connectionConfigCli = new ConnectionConfigCli((DatabaseTypeConfig)this.databaseTypeConfigCli);
    @ParametersDelegate
    private ProcessingConfigCli processingConfigCli = new ProcessingConfigCli(this.noRowsConfigCli, (DatabaseTypeConfig)this.databaseTypeConfigCli);
    @ParametersDelegate
    private TemplateDirectoryConfigCli templateDirectoryConfigCli = new TemplateDirectoryConfigCli();
    @ParametersDelegate
    private HtmlConfigCli htmlConfigCli = new HtmlConfigCli(this.noRowsConfigCli, this.templateDirectoryConfigCli);
    @ParametersDelegate
    private DotConfigCli dotConfigCli = new DotConfigCli(this.noRowsConfigCli, this.templateDirectoryConfigCli);
    @Parameter(names={"-vizjs", "schemaspy.vizjs"}, descriptionKey="vizjs", required=false)
    private boolean useVizJS = false;
    @Parameter(names={"-degree", "schemaspy.degree"}, descriptionKey="degree", required=false, validateValueWith={DegreeOfSeparationValidator.class})
    private int degreeOfSeparation = 2;
    @Parameter(names={"-noDbObjectPaging", "--noDbObjectPaging", "schemaspy.noDbObjectPaging"}, descriptionKey="noDbObjectPaging")
    private boolean noDbObjectPaging = false;
    @Parameter(names={"-dbObjectPageLength", "--dbObjectPageLength", "schemaspy.dbObjectPageLength"}, descriptionKey="dbObjectPageLength")
    private int dbObjectPageLength = 50;
    @Parameter(names={"-dbObjectLengthChange", "--dbObjectLengthChange", "schemaspy.dbObjectLengthChange"}, descriptionKey="dbObjectLengthChange")
    private boolean dbObjectLengthChange = false;
    @Parameter(names={"-noTablePaging", "--noTablePaging", "schemaspy.noTablePaging"}, descriptionKey="noTablePaging")
    private boolean noTablePaging = false;
    @Parameter(names={"-tablePageLength", "--tablePageLength", "schemaspy.tablePageLength"}, descriptionKey="tablePageLength")
    private int tablePageLength = 10;
    @Parameter(names={"-tableLengthChange", "--tableLengthChange", "schemaspy.tableLengthChange"}, descriptionKey="tableLengthChange")
    private boolean tableLengthChange = false;
    @Parameter(names={"-noIndexPaging", "--noIndexPaging", "schemaspy.noIndexPaging"}, descriptionKey="noIndexPaging")
    private boolean noIndexPaging = false;
    @Parameter(names={"-indexPageLength", "--indexPageLength", "schemaspy.indexPageLength"}, descriptionKey="indexPageLength")
    private int indexPageLength = 10;
    @Parameter(names={"-indexLengthChange", "--indexLengthChange", "schemaspy.indexLengthChange"}, descriptionKey="indexLengthChange")
    private boolean indexLengthChange = false;
    @Parameter(names={"-noCheckPaging", "--noCheckPaging", "schemaspy.noCheckPaging"}, descriptionKey="noCheckPaging")
    private boolean noCheckPaging = false;
    @Parameter(names={"-checkPageLength", "--checkPageLength", "schemaspy.checkPageLength"}, descriptionKey="checkPageLength")
    private int checkPageLength = 10;
    @Parameter(names={"-checkLengthChange", "--checkLengthChange", "schemaspy.checkLengthChange"}, descriptionKey="checkLengthChange")
    private boolean checkLengthChange = false;
    @Parameter(names={"-noRoutinePaging", "--noRoutinePaging", "schemaspy.noRoutinePaging"}, descriptionKey="noRoutinePaging")
    private boolean noRoutinePaging = false;
    @Parameter(names={"-routinePageLength", "--routinePageLength", "schemaspy.routinePageLength"}, descriptionKey="routinePageLength")
    private int routinePageLength = 50;
    @Parameter(names={"-routineLengthChange", "--routineLengthChange", "schemaspy.routineLengthChange"}, descriptionKey="routineLengthChange")
    private boolean routineLengthChange = false;
    @Parameter(names={"-noFkPaging", "--noFkPaging", "schemaspy.noFkPaging"}, descriptionKey="noFkPaging")
    private boolean noFkPaging = false;
    @Parameter(names={"-fkPageLength", "--fkPageLength", "schemaspy.fkPageLength"}, descriptionKey="fkPageLength")
    private int fkPageLength = 50;
    @Parameter(names={"-fkLengthChange", "--fkLengthChange", "schemaspy.fkLengthChange"}, descriptionKey="fkLengthChange")
    private boolean fkLengthChange = false;
    @Parameter(names={"-noColumnPaging", "--noColumnPaging", "schemaspy.noColumnPaging"}, descriptionKey="noColumnPaging")
    private boolean noColumnPaging = false;
    @Parameter(names={"-columnPageLength", "--columnPageLength", "schemaspy.columnPageLength"}, descriptionKey="columnPageLength")
    private int columnPageLength = 50;
    @Parameter(names={"-columnLengthChange", "--columnLengthChange", "schemaspy.columnLengthChange"}, descriptionKey="columnLengthChange")
    private boolean columnLengthChange = false;
    @Parameter(names={"-noAnomaliesPaging", "--noAnomaliesPaging", "schemaspy.noAnomaliesPaging"}, descriptionKey="noAnomaliesPaging")
    private boolean noAnomaliesPaging = false;
    @Parameter(names={"-anomaliesPageLength", "--anomaliesPageLength", "schemaspy.anomaliesPageLength"}, descriptionKey="anomaliesPageLength")
    private int anomaliesPageLength = 10;
    @Parameter(names={"-anomaliesLengthChange", "--anomaliesLengthChange", "schemaspy.anomaliesLengthChange"}, descriptionKey="anomaliesLengthChange")
    private boolean anomaliesLengthChange = false;

    public boolean isHelpRequired() {
        return this.helpRequired;
    }

    public boolean isDbHelpRequired() {
        return this.dbHelpRequired;
    }

    public boolean isPrintLicense() {
        return this.printLicense;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isHtmlDisabled() {
        return this.nohtml;
    }

    public boolean isHtmlEnabled() {
        return !this.nohtml;
    }

    public boolean withImpliedRelationships() {
        return !this.noImplied;
    }

    public boolean withOrphans() {
        return !this.noOrphans;
    }

    public boolean isRailsEnabled() {
        return this.railsEnabled;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isSingleSignOn() {
        return this.sso;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public boolean isEvaluateAllEnabled() {
        return this.evaluateAllEnabled;
    }

    public String getSchemaSpec() {
        if (Objects.nonNull(this.schemaSpec)) {
            return this.schemaSpec;
        }
        if (Objects.nonNull(this.databaseTypeConfigCli.getProperties().getProperty("schemaSpec"))) {
            return this.databaseTypeConfigCli.getProperties().getProperty("schemaSpec");
        }
        return ".*";
    }

    public List<String> getSchemas() {
        return new ArrayList<String>(this.schemas);
    }

    public String getSchemaMeta() {
        return this.schemaMeta;
    }

    public GraphvizConfig getGraphVizConfig() {
        return this.graphvizConfig;
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfigCli;
    }

    public ProcessingConfig getProcessingConfig() {
        return this.processingConfigCli;
    }

    public HtmlConfig getHtmlConfig() {
        return this.htmlConfigCli;
    }

    public DotConfig getDotConfig() {
        return this.dotConfigCli;
    }

    public boolean useVizJS() {
        return this.useVizJS;
    }

    public int getDegreeOfSeparation() {
        return this.degreeOfSeparation;
    }

    public boolean isNoDbObjectPaging() {
        return this.noDbObjectPaging;
    }

    public int getDbObjectPageLength() {
        return this.dbObjectPageLength;
    }

    public boolean isDbObjectLengthChange() {
        return this.dbObjectLengthChange;
    }

    public boolean isNoTablePaging() {
        return this.noTablePaging;
    }

    public int getTablePageLength() {
        return this.tablePageLength;
    }

    public boolean isTableLengthChange() {
        return this.tableLengthChange;
    }

    public boolean isNoIndexPaging() {
        return this.noIndexPaging;
    }

    public int getIndexPageLength() {
        return this.indexPageLength;
    }

    public boolean isIndexLengthChange() {
        return this.indexLengthChange;
    }

    public boolean isNoCheckPaging() {
        return this.noCheckPaging;
    }

    public int getCheckPageLength() {
        return this.checkPageLength;
    }

    public boolean isCheckLengthChange() {
        return this.checkLengthChange;
    }

    public boolean isNoRoutinePaging() {
        return this.noRoutinePaging;
    }

    public int getRoutinePageLength() {
        return this.routinePageLength;
    }

    public boolean isRoutineLengthChange() {
        return this.routineLengthChange;
    }

    public boolean isNoFkPaging() {
        return this.noFkPaging;
    }

    public int getFkPageLength() {
        return this.fkPageLength;
    }

    public boolean isFkLengthChange() {
        return this.fkLengthChange;
    }

    public boolean isNoColumnPaging() {
        return this.noColumnPaging;
    }

    public int getColumnPageLength() {
        return this.columnPageLength;
    }

    public boolean isColumnLengthChange() {
        return this.columnLengthChange;
    }

    public boolean isNoAnomaliesPaging() {
        return this.noAnomaliesPaging;
    }

    public int getAnomaliesPageLength() {
        return this.anomaliesPageLength;
    }

    public boolean isAnomaliesLengthChange() {
        return this.anomaliesLengthChange;
    }

    void setUnknownArgs(List<String> unknownArgs) {
        this.connectionConfigCli.setRemainingArguments(unknownArgs);
    }
}

