/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.cli;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.schemaspy.cli.CommandLineArguments;
import org.schemaspy.cli.ConfigFileArgument;
import org.schemaspy.cli.SchemaSpyJarFile;
import org.schemaspy.input.dbms.DatabaseTypes;
import org.schemaspy.input.dbms.config.PropertiesResolver;
import org.schemaspy.input.dbms.config.SimplePropertiesResolver;
import org.schemaspy.util.DbSpecificConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommandLineArgumentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PropertiesResolver propertiesResolver = new SimplePropertiesResolver();
    private static final String[] requiredFields = new String[]{"outputDirectory"};
    private final CommandLineArguments arguments = new CommandLineArguments();
    private final String[] args;
    private final JCommander jCommander;

    public CommandLineArgumentParser(String ... args) {
        this(null, args);
    }

    public CommandLineArgumentParser(IDefaultProvider defaultProvider, String ... args) {
        this.args = args;
        this.jCommander = JCommander.newBuilder().acceptUnknownOptions(true).programName("java -jar \"" + String.valueOf(Paths.get("", new String[0]).toAbsolutePath().relativize(new SchemaSpyJarFile().path())) + "\"").columnSize(120).defaultProvider(defaultProvider).build();
        this.jCommander.addObject((Object)new ConfigFileArgument());
        this.jCommander.addObject((Object)this.arguments);
    }

    public CommandLineArguments commandLineArguments() {
        this.jCommander.parse(this.args);
        this.arguments.setUnknownArgs(this.jCommander.getUnknownOptions());
        if (this.shouldValidate()) {
            this.validate();
        }
        return this.arguments;
    }

    private boolean shouldValidate() {
        List<ParameterDescription> helpParameters = this.jCommander.getParameters().stream().filter(ParameterDescription::isHelp).toList();
        for (ParameterDescription parameterDescription : helpParameters) {
            if (!parameterDescription.isAssigned()) continue;
            return false;
        }
        return true;
    }

    private void validate() {
        List runtimeRequiredFields = this.computeRequiredFields();
        ArrayList<CallSite> missingFields = new ArrayList<CallSite>();
        Map<String, ParameterDescription> fieldToParameterDescription = this.jCommander.getParameters().stream().collect(Collectors.toMap(parameterDescription -> parameterDescription.getParameterized().getName(), parameterDescription -> parameterDescription));
        for (String field : runtimeRequiredFields) {
            ParameterDescription parameterDescription2 = Objects.requireNonNull(fieldToParameterDescription.get(field), String.format("%s is declared required, but there is no ParameterDescription", field));
            if (!CommandLineArgumentParser.valueIsMissing((ParameterDescription)parameterDescription2)) continue;
            missingFields.add((CallSite)((Object)("[" + String.join((CharSequence)" | ", parameterDescription2.getParameter().names()) + "]")));
        }
        if (!missingFields.isEmpty()) {
            String message = String.join((CharSequence)", ", missingFields);
            throw new ParameterException("The following " + (missingFields.size() == 1 ? "option is required: " : "options are required: ") + message);
        }
    }

    private List<String> computeRequiredFields() {
        ArrayList<String> computedRequiredFields = new ArrayList<String>(Arrays.asList(requiredFields));
        if (!this.arguments.isSingleSignOn()) {
            computedRequiredFields.add("user");
        }
        return computedRequiredFields;
    }

    private static boolean valueIsMissing(ParameterDescription parameterDescription) {
        Object value = parameterDescription.getParameterized().get(parameterDescription.getObject());
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return Objects.isNull(value);
    }

    public void printUsage() {
        StringBuilder builder = new StringBuilder();
        this.jCommander.usage(builder);
        builder.append(System.lineSeparator());
        builder.append("Go to http://schemaspy.org for a complete list/description of additional parameters.");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("Sample usage using the default database type (implied -t ora):");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append(" java -jar schemaSpy.jar -db mydb -s myschema -u devuser -p password -o output");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        LOGGER.info("{}", (Object)builder);
    }

    public void printDatabaseTypesHelp() {
        LOGGER.info("Built-in database types and their required connection parameters:");
        TreeMap<String, List> builtIns = new TreeMap<String, List>();
        for (String type : new DatabaseTypes().getBuiltInDatabaseTypes()) {
            Properties props = propertiesResolver.getDbProperties(type);
            String dbms = props.getProperty("dbms");
            builtIns.putIfAbsent(dbms, new ArrayList());
            ((List)builtIns.get(dbms)).add(new DbSpecificConfig(type, props));
        }
        builtIns.forEach((key, types) -> {
            LOGGER.info(key);
            types.forEach(dbSpecificConfig -> dbSpecificConfig.dumpUsage(LOGGER));
        });
        LOGGER.info("You can use your own database types by specifying the filespec of a .properties file with -t.");
        LOGGER.info("Grab one out of {} and modify it to suit your needs.", (Object)new SchemaSpyJarFile().path());
    }

    public void printLicense() {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/COPYING"), StandardCharsets.UTF_8));
            try {
                bufferedReader.lines().forEachOrdered(arg_0 -> ((Logger)LOGGER).info(arg_0));
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read COPYING (GPL)", (Throwable)e);
        }
        LOGGER.info("");
        LOGGER.info("");
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/COPYING.LESSER"), StandardCharsets.UTF_8));
            try {
                bufferedReader.lines().forEachOrdered(arg_0 -> ((Logger)LOGGER).info(arg_0));
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read COPYING.LESSER (LGPL)", (Throwable)e);
        }
    }
}

