/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.Clock;
import java.time.Duration;
import java.time.InstantSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.io.FileUtils;
import org.schemaspy.DbAnalyzer;
import org.schemaspy.InsertionOrdered;
import org.schemaspy.LayoutFolder;
import org.schemaspy.OrderingReport;
import org.schemaspy.SimpleRuntimeDotConfig;
import org.schemaspy.analyzer.ImpliedConstraintsFinder;
import org.schemaspy.cli.CommandLineArguments;
import org.schemaspy.connection.SqlConnection;
import org.schemaspy.input.dbms.CatalogResolver;
import org.schemaspy.input.dbms.SchemaResolver;
import org.schemaspy.input.dbms.service.DatabaseService;
import org.schemaspy.input.dbms.service.DatabaseServiceFactory;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.input.dbms.xml.SchemaMeta;
import org.schemaspy.logging.Sanitize;
import org.schemaspy.model.Catalog;
import org.schemaspy.model.Console;
import org.schemaspy.model.Database;
import org.schemaspy.model.DbmsMeta;
import org.schemaspy.model.EmptySchemaException;
import org.schemaspy.model.ProgressListener;
import org.schemaspy.model.Routine;
import org.schemaspy.model.Schema;
import org.schemaspy.model.Table;
import org.schemaspy.model.Tracked;
import org.schemaspy.output.InfoHtml;
import org.schemaspy.output.OutputException;
import org.schemaspy.output.OutputProducer;
import org.schemaspy.output.diagram.Renderer;
import org.schemaspy.output.diagram.SummaryDiagram;
import org.schemaspy.output.diagram.TableDiagram;
import org.schemaspy.output.diagram.graphviz.GraphvizDot;
import org.schemaspy.output.diagram.vizjs.VizJSDot;
import org.schemaspy.output.dot.RuntimeDotConfig;
import org.schemaspy.output.dot.schemaspy.DefaultFontConfig;
import org.schemaspy.output.dot.schemaspy.DotFormatter;
import org.schemaspy.output.dot.schemaspy.FontConfig;
import org.schemaspy.output.dot.schemaspy.OrphanGraph;
import org.schemaspy.output.dot.schemaspy.graph.Graph;
import org.schemaspy.output.html.mustache.Diagram;
import org.schemaspy.output.html.mustache.diagrams.MustacheSummaryDiagramFactory;
import org.schemaspy.output.html.mustache.diagrams.MustacheSummaryDiagramResults;
import org.schemaspy.output.html.mustache.diagrams.MustacheTableDiagramFactory;
import org.schemaspy.output.html.mustache.diagrams.OrphanDiagram;
import org.schemaspy.progress.Condition;
import org.schemaspy.progress.ConditionalProgress;
import org.schemaspy.progress.IfUpdateAfter;
import org.schemaspy.util.DataTableConfig;
import org.schemaspy.util.DefaultPrintWriter;
import org.schemaspy.util.copy.CopyFromUrl;
import org.schemaspy.util.filefilter.NotHtml;
import org.schemaspy.util.naming.Name;
import org.schemaspy.util.naming.NameFromString;
import org.schemaspy.util.naming.SanitizedFileName;
import org.schemaspy.view.HtmlAnomaliesPage;
import org.schemaspy.view.HtmlColumnsPage;
import org.schemaspy.view.HtmlConstraintsPage;
import org.schemaspy.view.HtmlMainIndexPage;
import org.schemaspy.view.HtmlMultipleSchemasIndexPage;
import org.schemaspy.view.HtmlOrphansPage;
import org.schemaspy.view.HtmlRelationshipsPage;
import org.schemaspy.view.HtmlRoutinePage;
import org.schemaspy.view.HtmlRoutinesPage;
import org.schemaspy.view.HtmlTablePage;
import org.schemaspy.view.MustacheCompiler;
import org.schemaspy.view.SqlAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DOT_HTML = ".html";
    private static final String INDEX_DOT_HTML = "index.html";
    private static final String LOG_SCHEMAS_FORMAT = "\t'{}'";
    private final SqlService sqlService;
    private final DatabaseServiceFactory databaseServiceFactory;
    private final CommandLineArguments commandLineArguments;
    private final OutputProducer outputProducer;
    private final LayoutFolder layoutFolder;
    private final SqlConnection connection;

    public SchemaAnalyzer(SqlService sqlService, DatabaseServiceFactory databaseServiceFactory, CommandLineArguments commandLineArguments, OutputProducer outputProducer, LayoutFolder layoutFolder, SqlConnection connection) {
        this.sqlService = sqlService;
        this.databaseServiceFactory = databaseServiceFactory;
        this.commandLineArguments = commandLineArguments;
        this.outputProducer = outputProducer;
        this.layoutFolder = layoutFolder;
        this.connection = connection;
    }

    public Database analyze() throws SQLException, IOException {
        if (this.commandLineArguments.isEvaluateAllEnabled() || !this.commandLineArguments.getSchemas().isEmpty()) {
            return this.analyzeMultipleSchemas(this.databaseServiceFactory.forMultipleSchemas(this.commandLineArguments.getProcessingConfig()), this.connection);
        }
        File outputDirectory = this.commandLineArguments.getOutputDirectory();
        Objects.requireNonNull(outputDirectory);
        String schema = this.commandLineArguments.getSchema();
        return this.analyze(this.commandLineArguments.getConnectionConfig().getDatabaseName(), schema, false, outputDirectory, this.databaseServiceFactory.forSingleSchema(this.commandLineArguments.getProcessingConfig()), this.connection);
    }

    public Database analyzeMultipleSchemas(DatabaseService databaseService, SqlConnection con) throws SQLException, IOException {
        List schemas = this.commandLineArguments.getSchemas();
        Database db = null;
        DatabaseMetaData meta = con.connection().getMetaData();
        if (schemas.isEmpty()) {
            String schemaSpec = this.commandLineArguments.getSchemaSpec();
            LOGGER.info("Analyzing schemas that match regular expression '{}'. (use -schemaSpec on command line or in .properties to exclude other schemas)", (Object)new Sanitize(schemaSpec));
            schemas = DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta, (String)schemaSpec);
            if (schemas.isEmpty() && Objects.nonNull(this.commandLineArguments.getConnectionConfig().getUser())) {
                schemas.add(this.commandLineArguments.getConnectionConfig().getUser());
            }
            if (schemas.isEmpty()) {
                LOGGER.error("Couldn't find any schemas to analyze using schemaSpec '{}'", (Object)new Sanitize(schemaSpec));
                return null;
            }
        }
        LOGGER.info("Analyzing schemas:");
        schemas.forEach(schemaName -> LOGGER.info("\t'{}'", (Object)new Sanitize(schemaName)));
        File outputDir = this.commandLineArguments.getOutputDirectory();
        ArrayList<Schema> collectedSchemas = new ArrayList<Schema>();
        Catalog collectedCatalog = null;
        for (String schema : schemas) {
            String dbName = Objects.nonNull(this.commandLineArguments.getConnectionConfig().getDatabaseName()) ? this.commandLineArguments.getConnectionConfig().getDatabaseName() : schema;
            LOGGER.info("Analyzing '{}'", (Object)new Sanitize(schema));
            File outputDirForSchema = new File(outputDir, new SanitizedFileName((Name)new NameFromString(schema)).value());
            db = this.analyze(dbName, schema, true, outputDirForSchema, databaseService, con);
            if (db == null) {
                return null;
            }
            collectedSchemas.add(db.getSchema());
            collectedCatalog = db.getCatalog();
        }
        if (this.commandLineArguments.isHtmlEnabled()) {
            new CopyFromUrl(this.layoutFolder.url(), outputDir, (FileFilter)new NotHtml()).copy();
            DataTableConfig dataTableConfig = new DataTableConfig(this.commandLineArguments);
            MustacheCompiler mustacheCompiler = new MustacheCompiler(this.commandLineArguments.getConnectionConfig().getDatabaseName(), null, this.commandLineArguments.getHtmlConfig(), true, dataTableConfig);
            HtmlMultipleSchemasIndexPage htmlMultipleSchemasIndexPage = new HtmlMultipleSchemasIndexPage(mustacheCompiler);
            try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("index.html").toFile());){
                htmlMultipleSchemasIndexPage.write(collectedCatalog, collectedSchemas, this.commandLineArguments.getHtmlConfig().getDescription(), SchemaAnalyzer.getDatabaseProduct((DatabaseMetaData)meta), (Writer)writer);
                LOGGER.info("Access navigation to reports by opening {}", (Object)new File(outputDir, "index.html"));
            }
        }
        return db;
    }

    private static String getDatabaseProduct(DatabaseMetaData meta) {
        try {
            return meta.getDatabaseProductName() + " - " + meta.getDatabaseProductVersion();
        }
        catch (SQLException exc) {
            return "";
        }
    }

    public Database analyze(String dbName, String schema, boolean isOneOfMultipleSchemas, File outputDir, DatabaseService databaseService, SqlConnection connection) throws SQLException, IOException {
        SchemaMeta schemaMeta;
        LOGGER.info("Starting schema analysis");
        Console progressListener = new Console(outputDir, (ProgressListener)new Tracked());
        FileUtils.forceMkdir((File)outputDir);
        String catalog = this.commandLineArguments.getCatalog();
        DatabaseMetaData databaseMetaData = this.sqlService.connect(connection);
        DbmsMeta dbmsMeta = this.sqlService.getDbmsMeta();
        LOGGER.info("Connected to {} - {}", (Object)databaseMetaData.getDatabaseProductName(), (Object)databaseMetaData.getDatabaseProductVersion());
        LOGGER.debug("supportsSchemasInTableDefinitions: {}", (Object)databaseMetaData.supportsSchemasInTableDefinitions());
        LOGGER.debug("supportsCatalogsInTableDefinitions: {}", (Object)databaseMetaData.supportsCatalogsInTableDefinitions());
        catalog = new CatalogResolver(databaseMetaData).resolveCatalog(catalog);
        schema = new SchemaResolver(databaseMetaData).resolveSchema(schema);
        SchemaMeta schemaMeta2 = schemaMeta = this.commandLineArguments.getSchemaMeta() == null ? null : new SchemaMeta(this.commandLineArguments.getSchemaMeta(), dbName, schema, isOneOfMultipleSchemas);
        if (schemaMeta != null && schemaMeta.getFile() != null) {
            LOGGER.info("Using additional metadata from {}", (Object)schemaMeta.getFile());
        }
        Database db = new Database(dbmsMeta, dbName, catalog, schema);
        databaseService.gatherSchemaDetails(db, schemaMeta, (ProgressListener)progressListener);
        ArrayList tables = new ArrayList(db.getTables());
        tables.addAll(db.getViews());
        if (tables.isEmpty()) {
            SchemaAnalyzer.dumpNoTablesMessage((String)schema, (String)this.commandLineArguments.getConnectionConfig().getUser(), (DatabaseMetaData)databaseMetaData, (!".*".equals(this.commandLineArguments.getProcessingConfig().getTableInclusions().toString()) ? 1 : 0) != 0);
            if (!isOneOfMultipleSchemas) {
                throw new EmptySchemaException();
            }
        }
        if (this.commandLineArguments.isHtmlEnabled()) {
            this.generateHtmlDoc(schema, isOneOfMultipleSchemas, this.commandLineArguments.useVizJS(), (ProgressListener)progressListener, outputDir, db, tables);
        }
        try {
            this.outputProducer.generate(db, outputDir);
        }
        catch (OutputException oe) {
            if (isOneOfMultipleSchemas) {
                LOGGER.warn("Failed to produce output", (Throwable)oe);
            }
            throw oe;
        }
        List orderedTables = new InsertionOrdered(db).getTablesOrderedByRI();
        new OrderingReport(outputDir, orderedTables).write();
        progressListener.finished(tables);
        return db;
    }

    private void generateHtmlDoc(String schema, boolean isOneOfMultipleSchemas, boolean useVizJS, ProgressListener progressListener, File outputDir, Database db, Collection<Table> tables) throws IOException {
        boolean hasRealConstraints;
        FileUtils.forceMkdir((File)new File(outputDir, "tables"));
        FileUtils.forceMkdir((File)new File(outputDir, "diagrams/summary"));
        this.commandLineArguments.getHtmlConfig().registryPage(tables);
        new CopyFromUrl(this.layoutFolder.url(), outputDir, (FileFilter)new NotHtml()).copy();
        VizJSDot renderer = useVizJS ? new VizJSDot() : new GraphvizDot(this.commandLineArguments.getGraphVizConfig());
        new InfoHtml(outputDir, (Renderer)renderer).write();
        progressListener.startCreatingSummaries();
        boolean bl = hasRealConstraints = !db.getRemoteTables().isEmpty() || tables.stream().anyMatch(table -> !table.isOrphan(false));
        if (this.commandLineArguments.isRailsEnabled()) {
            DbAnalyzer.getRailsConstraints((Map)db.getTablesMap());
        }
        ImpliedConstraintsFinder impliedConstraintsFinder = new ImpliedConstraintsFinder();
        List impliedConstraints = this.commandLineArguments.withImpliedRelationships() ? impliedConstraintsFinder.find(tables) : Collections.emptyList();
        SimpleRuntimeDotConfig runtimeDotConfig = new SimpleRuntimeDotConfig((FontConfig)new DefaultFontConfig(this.commandLineArguments.getDotConfig()), this.commandLineArguments.getDotConfig(), "svg".equalsIgnoreCase(renderer.format()), isOneOfMultipleSchemas);
        DotFormatter dotProducer = new DotFormatter((RuntimeDotConfig)runtimeDotConfig, this.commandLineArguments.withOrphans());
        File diagramDir = new File(outputDir, "diagrams");
        diagramDir.mkdirs();
        File summaryDir = new File(diagramDir, "summary");
        summaryDir.mkdirs();
        SummaryDiagram summaryDiagram = new SummaryDiagram((Renderer)renderer, summaryDir);
        MustacheSummaryDiagramFactory mustacheSummaryDiagramFactory = new MustacheSummaryDiagramFactory(dotProducer, summaryDiagram, hasRealConstraints, !impliedConstraints.isEmpty(), outputDir, progressListener);
        MustacheSummaryDiagramResults results = mustacheSummaryDiagramFactory.generateSummaryDiagrams(db, tables);
        results.getOutputExceptions().stream().forEachOrdered(exception -> LOGGER.error("RelationShipDiagramError", (Throwable)exception));
        DataTableConfig dataTableConfig = new DataTableConfig(this.commandLineArguments);
        MustacheCompiler mustacheCompiler = new MustacheCompiler(db.getName(), schema, this.commandLineArguments.getHtmlConfig(), isOneOfMultipleSchemas, dataTableConfig);
        HtmlRelationshipsPage htmlRelationshipsPage = new HtmlRelationshipsPage(mustacheCompiler, hasRealConstraints, !impliedConstraints.isEmpty());
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("relationships.html").toFile());){
            htmlRelationshipsPage.write(results, (Writer)writer);
            progressListener.createdSummary();
        }
        HtmlOrphansPage htmlOrphansPage = new HtmlOrphansPage(mustacheCompiler, (Diagram)new OrphanDiagram((Graph)new OrphanGraph((RuntimeDotConfig)runtimeDotConfig, tables), (Renderer)renderer, outputDir));
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("orphans.html").toFile());){
            htmlOrphansPage.write((Writer)writer);
            progressListener.createdSummary();
        }
        HtmlMainIndexPage htmlMainIndexPage = new HtmlMainIndexPage(mustacheCompiler, this.commandLineArguments.getHtmlConfig().getDescription());
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("index.html").toFile());){
            htmlMainIndexPage.write(db, tables, impliedConstraints, (Writer)writer);
        }
        List constraints = DbAnalyzer.getForeignKeyConstraints(tables);
        HtmlConstraintsPage htmlConstraintsPage = new HtmlConstraintsPage(mustacheCompiler);
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("constraints.html").toFile());){
            htmlConstraintsPage.write(constraints, tables, (Writer)writer);
        }
        HtmlAnomaliesPage htmlAnomaliesPage = new HtmlAnomaliesPage(mustacheCompiler);
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("anomalies.html").toFile());){
            htmlAnomaliesPage.write(tables, impliedConstraints, (Writer)writer);
        }
        HtmlColumnsPage htmlColumnsPage = new HtmlColumnsPage(mustacheCompiler);
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("columns.html").toFile());){
            htmlColumnsPage.write(tables, (Writer)writer);
        }
        progressListener.finishedCreatingSummaries();
        HtmlRoutinesPage htmlRoutinesPage = new HtmlRoutinesPage(mustacheCompiler);
        try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("routines.html").toFile());){
            htmlRoutinesPage.write(db.getRoutines(), (Writer)writer);
        }
        new ConditionalProgress(increments -> LOGGER.info("Written {} routines pages...", (Object)increments), (increments, duration) -> LOGGER.info("Wrote {} routines pages in {} seconds", (Object)increments, (Object)duration.toSeconds()), (Condition)new IfUpdateAfter(Duration.ofSeconds(10L), (InstantSource)Clock.systemDefaultZone()), progress -> {
            LOGGER.info("Writing routines pages");
            HtmlRoutinePage htmlRoutinePage = new HtmlRoutinePage(mustacheCompiler);
            for (Routine routine : db.getRoutines()) {
                try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("routines").resolve(new SanitizedFileName((Name)new NameFromString(routine.getName())).value() + ".html").toFile());){
                    htmlRoutinePage.write(routine, (Writer)writer);
                    progress.progressed();
                }
            }
        }, (InstantSource)Clock.systemDefaultZone()).execute();
        progressListener.startCreatingTablePages();
        SqlAnalyzer sqlAnalyzer = new SqlAnalyzer(db.getDbmsMeta().getIdentifierQuoteString(), db.getDbmsMeta().reservedWords(), db.getTables(), db.getViews());
        File tablesDir = new File(diagramDir, "tables");
        tablesDir.mkdirs();
        TableDiagram tableDiagram = new TableDiagram((Renderer)renderer, tablesDir);
        MustacheTableDiagramFactory mustacheTableDiagramFactory = new MustacheTableDiagramFactory(dotProducer, tableDiagram, outputDir, this.commandLineArguments.getDegreeOfSeparation());
        HtmlTablePage htmlTablePage = new HtmlTablePage(mustacheCompiler, sqlAnalyzer);
        for (Table table2 : tables) {
            List mustacheTableDiagrams = mustacheTableDiagramFactory.generateTableDiagrams(table2);
            LOGGER.debug("Writing details of {}", (Object)table2.getName());
            try (DefaultPrintWriter writer = new DefaultPrintWriter(outputDir.toPath().resolve("tables").resolve(new SanitizedFileName((Name)new NameFromString(table2.getName())).value() + ".html").toFile());){
                htmlTablePage.write(table2, mustacheTableDiagrams, (Writer)writer);
                progressListener.createdTablePage(table2);
            }
        }
        progressListener.finishedCreatingTablePages();
        LOGGER.info("View the results by opening {}", (Object)new File(outputDir, "index.html"));
    }

    private static void dumpNoTablesMessage(String schema, String user, DatabaseMetaData meta, boolean specifiedInclusions) throws SQLException {
        List schemas;
        LOGGER.warn("No tables or views were found in schema '{}'.", (Object)new Sanitize(schema));
        try {
            schemas = DbAnalyzer.getSchemas((DatabaseMetaData)meta);
        }
        catch (RuntimeException | SQLException exc) {
            LOGGER.error("The user you specified '{}' might not have rights to read the database metadata.", (Object)new Sanitize(user), (Object)exc);
            return;
        }
        if (schemas.isEmpty()) {
            try {
                schemas = DbAnalyzer.getCatalogs((DatabaseMetaData)meta);
            }
            catch (RuntimeException | SQLException exc) {
                LOGGER.error("The user you specified '{}' might not have rights to read the database metadata.", (Object)new Sanitize(user), (Object)exc);
                return;
            }
        }
        if (schemas.contains(schema)) {
            LOGGER.error("The schema exists in the database, but the user you specified '{}'might not have rights to read its contents.", (Object)new Sanitize(user));
            if (specifiedInclusions) {
                LOGGER.error("Another possibility is that the regular expression that you specified for what to include (via -i) didn't match any tables.");
            }
        } else {
            LOGGER.error("The schema '{}' could not be read/found, schema is specified using the -s option.", (Object)new Sanitize(schema));
            LOGGER.error("Make sure user '{}' has the correct privileges to read the schema.", (Object)new Sanitize(user));
            LOGGER.error("Also not that schema names are usually case sensitive.");
            List populatedSchemas = DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta);
            if (populatedSchemas.isEmpty()) {
                LOGGER.error("Unable to determine if any of the schemas are visible to '{}'", (Object)new Sanitize(user));
            } else {
                LOGGER.info("Schemas with tables/views visible to '{}':", (Object)new Sanitize(user));
                populatedSchemas.forEach(schemaName -> LOGGER.info("\t'{}'", (Object)new Sanitize(schemaName)));
            }
            List<String> otherSchemas = schemas.stream().filter(Predicate.not(populatedSchemas::contains)).toList();
            if (!otherSchemas.isEmpty()) {
                LOGGER.info("Other available schemas(Some of these may be system schemas):");
                otherSchemas.forEach(schemaName -> LOGGER.info("\t'{}'", (Object)new Sanitize(schemaName)));
            }
        }
    }
}

