/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.beust.jcommander.ParameterException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.stream.Stream;
import org.schemaspy.LayoutFolder;
import org.schemaspy.SchemaAnalyzer;
import org.schemaspy.cli.Banner;
import org.schemaspy.cli.CommandLineArgumentParser;
import org.schemaspy.cli.CommandLineArguments;
import org.schemaspy.cli.ConfigFileArgumentParser;
import org.schemaspy.cli.DefaultProviderFactory;
import org.schemaspy.cli.RuntimeInfo;
import org.schemaspy.cli.SchemaSpyRunner;
import org.schemaspy.connection.ScExceptionChecked;
import org.schemaspy.connection.ScNullChecked;
import org.schemaspy.connection.ScSimple;
import org.schemaspy.connection.SqlConnection;
import org.schemaspy.input.dbms.ConnectionConfig;
import org.schemaspy.input.dbms.ConnectionURLBuilder;
import org.schemaspy.input.dbms.DriverFromConfig;
import org.schemaspy.input.dbms.driver.Driversource;
import org.schemaspy.input.dbms.service.DatabaseServiceFactory;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.output.OutputProducer;
import org.schemaspy.output.xml.dom.XmlProducerUsingDOM;
import org.schemaspy.util.ManifestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void main(String ... args) {
        System.setProperty("java.awt.headless", "true");
        System.out.println(new Banner("/banner.txt", Map.of("${application.version}", ManifestUtils.getImplementationVersion())).banner());
        LOGGER.info("{}", (Object)new RuntimeInfo("SchemaSpy", ManifestUtils.getImplementationVersion()));
        if (Stream.of(args).anyMatch(arg -> "-debug".equals(arg) || "--debug".equals(arg))) {
            Main.enableDebug();
        }
        try {
            CommandLineArgumentParser commandLineArgumentParser = new CommandLineArgumentParser(new DefaultProviderFactory(new ConfigFileArgumentParser(args).configFile()).defaultProvider(), args);
            CommandLineArguments arguments = commandLineArgumentParser.commandLineArguments();
            Main.run((CommandLineArgumentParser)commandLineArgumentParser, (CommandLineArguments)arguments, (String[])args);
        }
        catch (ParameterException pe) {
            LOGGER.error("Invalid command line arguments:", (Throwable)pe);
            System.exit(1);
        }
    }

    private static void run(CommandLineArgumentParser commandLineArgumentParser, CommandLineArguments arguments, String ... args) {
        if (arguments.isHelpRequired()) {
            commandLineArgumentParser.printUsage();
            System.exit(0);
        }
        if (arguments.isDbHelpRequired()) {
            commandLineArgumentParser.printDatabaseTypesHelp();
            System.exit(0);
        }
        if (arguments.isPrintLicense()) {
            commandLineArgumentParser.printLicense();
            System.exit(0);
        }
        if (arguments.isDebug()) {
            Main.enableDebug();
        }
        SqlService sqlService = new SqlService();
        ConnectionConfig connectionConfig = arguments.getConnectionConfig();
        ConnectionURLBuilder urlBuilder = new ConnectionURLBuilder(connectionConfig);
        SchemaSpyRunner schemaSpyRunner = new SchemaSpyRunner(new SchemaAnalyzer(sqlService, new DatabaseServiceFactory(sqlService), arguments, (OutputProducer)new XmlProducerUsingDOM(), new LayoutFolder(SchemaAnalyzer.class.getClassLoader()), (SqlConnection)new ScExceptionChecked(urlBuilder, (SqlConnection)new ScNullChecked(urlBuilder, (SqlConnection)new ScSimple(connectionConfig, urlBuilder, (Driversource)new DriverFromConfig(connectionConfig))))), arguments, args);
        System.exit(schemaSpyRunner.run());
    }

    private static void enableDebug() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = context.getLogger("org.schemaspy");
        if (!logger.isDebugEnabled()) {
            logger.setLevel(Level.DEBUG);
            LOGGER.debug("Debug enabled");
        }
    }
}

