/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy;

import java.lang.invoke.MethodHandles;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.PrimaryTableColumn;
import org.schemaspy.model.RailsForeignKeyConstraint;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.model.Tables;
import org.schemaspy.model.TablesMap;
import org.schemaspy.util.Filtered;
import org.schemaspy.util.WhenFalse;
import org.schemaspy.util.WhenIf;
import org.schemaspy.util.naming.Name;
import org.schemaspy.util.rails.NmPrimaryTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DbAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static List<RailsForeignKeyConstraint> getRailsConstraints(Map<String, Table> tables) {
        ArrayList<RailsForeignKeyConstraint> railsConstraints = new ArrayList<RailsForeignKeyConstraint>(tables.size());
        for (Table table : tables.values()) {
            for (TableColumn column : table.getColumns()) {
                TableColumn primaryColumn;
                if (column.isForeignKey() || !column.allowsImpliedParents() || (primaryColumn = new PrimaryTableColumn((Tables)new TablesMap(tables), (Name)new NmPrimaryTable(column.getName())).column()) == null) continue;
                railsConstraints.add(new RailsForeignKeyConstraint(primaryColumn, column));
            }
        }
        return railsConstraints;
    }

    public static List<ForeignKeyConstraint> getForeignKeyConstraints(Collection<Table> tables) {
        ArrayList<ForeignKeyConstraint> constraints = new ArrayList<ForeignKeyConstraint>();
        for (Table table : tables) {
            constraints.addAll(table.getForeignKeys());
        }
        return constraints;
    }

    public static List<Table> getTablesWithoutIndexes(Collection<Table> tables) {
        ArrayList<Table> withoutIndexes = new ArrayList<Table>();
        for (Table table : tables) {
            if (!table.getIndexes().isEmpty() || table.isView() || table.isLogical()) continue;
            withoutIndexes.add(table);
        }
        return DbAnalyzer.sortTablesByName(withoutIndexes);
    }

    public static List<Table> getTablesWithIncrementingColumnNames(Collection<Table> tables) {
        ArrayList<Table> denormalizedTables = new ArrayList<Table>();
        block0: for (Table table : tables) {
            HashMap<String, Long> columnPrefixes = new HashMap<String, Long>();
            for (TableColumn column : table.getColumns()) {
                Object columnName = column.getName();
                String numbers = DbAnalyzer.trailingDigits((String)columnName);
                if (numbers == null) {
                    numbers = "1";
                    columnName = (String)columnName + numbers;
                }
                String prefix = ((String)columnName).substring(0, ((String)columnName).length() - numbers.length());
                long numeric = Long.parseLong(numbers);
                Long existing = (Long)columnPrefixes.get(prefix);
                if (existing != null && Math.abs(existing - numeric) == 1L) {
                    denormalizedTables.add(table);
                    continue block0;
                }
                columnPrefixes.put(prefix, numeric);
            }
        }
        return DbAnalyzer.sortTablesByName(denormalizedTables);
    }

    private static String trailingDigits(String columnName) {
        String numbers = null;
        for (int i = columnName.length() - 1; i > 0 && Character.isDigit(columnName.charAt(i)); --i) {
            numbers = String.valueOf(columnName.charAt(i)) + (String)(numbers == null ? "" : numbers);
        }
        return numbers;
    }

    public static List<Table> getTablesWithOneColumn(Collection<Table> tables) {
        ArrayList<Table> singleColumnTables = new ArrayList<Table>();
        for (Table table : tables) {
            if (table.getColumns().size() != 1) continue;
            singleColumnTables.add(table);
        }
        return DbAnalyzer.sortTablesByName(singleColumnTables);
    }

    public static List<Table> sortTablesByName(List<Table> tables) {
        tables.sort(Table::compareTo);
        return tables;
    }

    public static List<TableColumn> sortColumnsByTable(List<TableColumn> columns) {
        columns.sort((column1, column2) -> {
            int rc = column1.getTable().compareTo(column2.getTable());
            if (rc == 0) {
                rc = column1.getName().compareToIgnoreCase(column2.getName());
            }
            return rc;
        });
        return columns;
    }

    public static List<TableColumn> getDefaultNullStringColumns(Collection<Table> tables) {
        ArrayList<TableColumn> defaultNullStringColumns = new ArrayList<TableColumn>();
        for (Table table : tables) {
            for (TableColumn column : table.getColumns()) {
                String defaultString;
                Object defaultValue = column.getDefaultValue();
                if (!(defaultValue instanceof String) || !"'null'".equalsIgnoreCase((defaultString = defaultValue.toString()).trim())) continue;
                defaultNullStringColumns.add(column);
            }
        }
        return DbAnalyzer.sortColumnsByTable(defaultNullStringColumns);
    }

    public static List<String> getCatalogs(DatabaseMetaData meta) throws SQLException {
        ArrayList<String> catalogs = new ArrayList<String>();
        ResultSet rs = meta.getCatalogs();
        while (rs.next()) {
            catalogs.add(rs.getString("TABLE_CAT"));
        }
        rs.close();
        return catalogs;
    }

    public static List<String> getSchemas(DatabaseMetaData meta) throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        ResultSet rs = meta.getSchemas();
        while (rs.next()) {
            schemas.add(rs.getString("TABLE_SCHEM"));
        }
        rs.close();
        return schemas;
    }

    public static List<String> getPopulatedSchemas(DatabaseMetaData meta) throws SQLException {
        return DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta, (String)".*");
    }

    public static List<String> getPopulatedSchemas(DatabaseMetaData meta, String schemaSpec) throws SQLException {
        List populatedSchemas = DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta, (String)schemaSpec, (List)DbAnalyzer.getSchemas((DatabaseMetaData)meta));
        if (populatedSchemas.isEmpty()) {
            return DbAnalyzer.getPopulatedSchemas((DatabaseMetaData)meta, (String)schemaSpec, (List)DbAnalyzer.getCatalogs((DatabaseMetaData)meta));
        }
        return populatedSchemas;
    }

    public static List<String> getPopulatedSchemas(DatabaseMetaData meta, String schemaSpec, List<String> candidates) {
        Pattern schemaRegex = Pattern.compile(schemaSpec);
        Filtered matched = new Filtered(candidates, (Predicate)new WhenFalse(schema -> schemaRegex.matcher((CharSequence)schema).matches(), schema -> LOGGER.debug("Excluding schema {}: doesn't match '{}'", schema, (Object)schemaRegex)));
        Filtered populated = new Filtered((Iterable)matched, (Predicate)new WhenIf(schema -> DbAnalyzer.hasTables((DatabaseMetaData)meta, (String)schema), schema -> LOGGER.debug("Including schema {}: matches + \"{}\" and contains tables", schema, (Object)schemaRegex), schema -> LOGGER.debug("Excluding schema {}: matches \"{}\" but contains no tables", schema, (Object)schemaRegex)));
        return StreamSupport.stream(populated.spliterator(), false).distinct().sorted().toList();
    }

    public static boolean hasTables(DatabaseMetaData meta, String schema) {
        boolean bl;
        block8: {
            ResultSet rs = meta.getTables(null, schema, "%", null);
            try {
                bl = rs.next();
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return false;
                }
            }
            rs.close();
        }
        return bl;
    }
}

