/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.nbtedit.packets;

import com.mcf.davidee.nbtedit.NBTEdit;
import com.mcf.davidee.nbtedit.NBTHelper;
import com.mcf.davidee.nbtedit.packets.AbstractPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S06PacketUpdateHealth;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.world.WorldSettings;

public class EntityNBTPacket
extends AbstractPacket {
    protected int entityID;
    protected NBTTagCompound tag;

    public EntityNBTPacket() {
    }

    public EntityNBTPacket(int entityID, NBTTagCompound tag) {
        this.entityID = entityID;
        this.tag = tag;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        ByteBufOutputStream bos = new ByteBufOutputStream(buffer);
        bos.writeInt(this.entityID);
        NBTHelper.nbtWrite(this.tag, (DataOutput)bos);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        ByteBufInputStream bis = new ByteBufInputStream(buffer);
        DataInputStream nbt = new DataInputStream((InputStream)bis);
        this.entityID = bis.readInt();
        this.tag = NBTHelper.nbtRead(nbt);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        NBTEdit.proxy.openEditGUI(this.entityID, this.tag);
    }

    @Override
    public void handleServerSide(EntityPlayerMP player) {
        Entity e = player.field_70170_p.func_73045_a(this.entityID);
        if (e != null) {
            try {
                WorldSettings.GameType preGameType = player.field_71134_c.func_73081_b();
                e.func_70020_e(this.tag);
                NBTEdit.log(Level.FINE, player.func_70005_c_() + " edited a tag -- Entity ID #" + this.entityID);
                NBTEdit.logTag(this.tag);
                if (e == player) {
                    player.func_71120_a(player.field_71069_bz);
                    WorldSettings.GameType type = player.field_71134_c.func_73081_b();
                    if (preGameType != type) {
                        player.func_71033_a(type);
                    }
                    player.field_71135_a.func_147359_a((Packet)new S06PacketUpdateHealth(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
                    player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
                    player.func_71016_p();
                }
                this.sendMessageToPlayer((EntityPlayer)player, "Your changes have been saved");
            }
            catch (Throwable t) {
                this.sendMessageToPlayer((EntityPlayer)player, "\u00a7cSave Failed - Invalid NBT format for Entity");
                NBTEdit.log(Level.WARNING, player.func_70005_c_() + " edited a tag and caused an exception");
                NBTEdit.logTag(this.tag);
                NBTEdit.throwing("EntityNBTPacket", "handleServerSide", t);
            }
        }
    }
}

